/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class Statistics
extends AbstractViewPlugin {
    private static final long serialVersionUID = 8565680908628147610L;

    public String globalInfo() {
        return "Generates a table with some simple statistics.";
    }

    @Override
    public String getMenuText() {
        return "Statistics";
    }

    @Override
    public String getMenuIcon() {
        return "statistics.png";
    }

    @Override
    protected BasePanel doGenerate(SpreadSheet sheet) {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        Hashtable<Cell.ContentType, Integer> counts = new Hashtable<Cell.ContentType, Integer>();
        for (Cell.ContentType ct : Cell.ContentType.values()) {
            if (ct == Cell.ContentType.MISSING) continue;
            counts.put(ct, 0);
        }
        ArrayList<Cell.ContentType> numeric = new ArrayList<Cell.ContentType>(Arrays.asList(Cell.ContentType.DOUBLE, Cell.ContentType.LONG));
        for (int i = 0; i < sheet.getColumnCount(); ++i) {
            ArrayList types = new ArrayList(sheet.getContentTypes(i));
            if (types.size() == 1) {
                counts.put((Cell.ContentType)types.get(0), (Integer)counts.get(types.get(0)) + 1);
                continue;
            }
            if (types.size() != numeric.size() || !types.containsAll(numeric)) continue;
            counts.put(Cell.ContentType.DOUBLE, (Integer)counts.get(Cell.ContentType.DOUBLE) + 1);
        }
        DefaultSpreadSheet stats = new DefaultSpreadSheet();
        HeaderRow row = stats.getHeaderRow();
        row.addCell("key").setContent("Key");
        row.addCell("value").setContent("Value");
        row = stats.addRow();
        row.addCell(0).setContent("Rows");
        row.addCell(1).setContent(Integer.valueOf(sheet.getRowCount()));
        row = stats.addRow();
        row.addCell(0).setContent("Columns");
        row.addCell(1).setContent(Integer.valueOf(sheet.getColumnCount()));
        for (Cell.ContentType ct : Cell.ContentType.values()) {
            if (ct == Cell.ContentType.MISSING) continue;
            row = stats.addRow();
            row.addCell(0).setContent(ct + " columns");
            row.addCell(1).setContent((Integer)counts.get(ct));
        }
        SpreadSheetTable table = new SpreadSheetTable((SpreadSheet)stats);
        table.setAutoResizeMode(0);
        table.setOptimalColumnWidth();
        result.add((Component)new BaseScrollPane((Component)table));
        return result;
    }
}

