/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.menu;

import adams.core.UniqueIDs;
import adams.data.conversion.StringToSpreadSheet;
import adams.data.io.input.SimpleCsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.menu.AbstractSpreadSheetViewerMenuItemAction;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;

public class EditPasteAsNew
extends AbstractSpreadSheetViewerMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;
    public static final String CLIPBOARD = "clipboard";
    protected SpreadSheetReader m_LastReader;

    protected String getTitle() {
        return "Paste as new...";
    }

    protected GenericObjectEditorDialog createDialog() {
        GenericObjectEditorDialog result = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        result.setTitle("Import of clipboard content");
        result.getGOEEditor().setClassType(SpreadSheetReader.class);
        result.getGOEEditor().setCanChangeClassInDialog(true);
        result.setCurrent((Object)this.m_LastReader);
        result.setLocationRelativeTo((Component)this.m_State);
        return result;
    }

    protected void doActionPerformed(ActionEvent e) {
        if (this.m_LastReader == null) {
            this.m_LastReader = new SimpleCsvSpreadSheetReader();
            ((SimpleCsvSpreadSheetReader)this.m_LastReader).setNoHeader(true);
            ((SimpleCsvSpreadSheetReader)this.m_LastReader).setSeparator("\\t");
        }
        ((GenericObjectEditorDialog)this.getDialog()).setVisible(true);
        if (((GenericObjectEditorDialog)this.getDialog()).getResult() != 0) {
            return;
        }
        this.m_LastReader = (SpreadSheetReader)((GenericObjectEditorDialog)this.getDialog()).getCurrent();
        StringToSpreadSheet conv = new StringToSpreadSheet();
        conv.setReader(this.m_LastReader);
        conv.setInput(ClipboardHelper.pasteStringFromClipboard());
        String msg = conv.convert();
        if (msg == null) {
            ((SpreadSheetViewerPanel)((Object)this.m_State)).getMultiPagePane().addPage("clipboard-" + UniqueIDs.nextInt((String)CLIPBOARD), (SpreadSheet)conv.getOutput());
        } else {
            GUIHelper.showErrorMessage((Component)((Component)this.m_State), (String)("Failed to parse clipboard content!\n" + msg));
        }
        conv.cleanUp();
    }

    protected void doUpdate() {
        this.setEnabled(ClipboardHelper.canPasteStringFromClipboard());
    }
}

