/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.lookupupdate.Parser;
import adams.parser.lookupupdate.Scanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class LookUpUpdate
extends AbstractSymbolEvaluator<SpreadSheet> {
    private static final long serialVersionUID = 8014316012335802585L;
    protected SpreadSheet m_Sheet;
    protected SpreadSheetReader m_Reader;
    protected PlaceholderFile m_Input;
    protected SpreadSheetColumnIndex m_KeyColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Evaluates lookup update rules updating the spreadsheet.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("input", "input", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public String getGrammar() {
        return "expr_list ::= expr_list expr_part | expr_part\n\nexpr_part ::= conditional | assignment\n\nconditional ::=   if expr then assignments end\n                | if expr then assignments else assignments end\n\nassignments ::= assignments assignment | assignment\nassignment ::=\n                VARIABLE := expr;\n              | all ( \"regexp\" ) := expr;\n\nexpr ::=        ( expr )\n              | NUMBER\n              | STRING\n              | BOOLEAN\n              | VARIABLE\n\n              | true\n              | false\n\n              | -expr\n\n              | expr < expr\n              | expr <= expr\n              | expr > expr\n              | expr >= expr\n              | expr = expr\n              | expr != expr\n\n              | not expr\n              | expr and expr\n              | expr or expr\n\n# string functions\n              | substr ( expr , start [, end] )\n              | left ( expr , len )\n              | mid ( expr , start , len )\n              | right ( expr , len )\n              | rept ( expr , count )\n              | concatenate ( expr1 , expr2 [, expr3-5] )\n              | lower[case] ( expr )\n              | upper[case] ( expr )\n              | trim ( expr )\n              | matches ( expr , regexp )\n              | len[gth] ( str )\n              | find ( search , expr [, pos] ) (find 'search' in 'expr', return 1-based position)\n              | contains ( str , find ) (checks whether 'str' string contains 'find' string)\n              | replace ( str , pos , len , newstr )\n              | replaceall ( str , regexp , replace ) (applies regular expression to 'str' and replaces all matches with 'replace')\n              | substitute ( str , find , replace [, occurrences] )\n              | str ( expr )\n              | str ( expr  , numdecimals )\n              | str ( expr  , decimalformat )\n\n              | expr + expr\n              | expr - expr\n              | expr * expr\n              | expr / expr\n              | expr % expr\n              | expr ^ expr\n\n              | abs ( expr )\n              | sqrt ( expr )\n              | cbrt ( expr )\n              | log ( expr )\n              | log10 ( expr )\n              | exp ( expr )\n              | sin ( expr )\n              | sinh ( expr )\n              | cos ( expr )\n              | cosh ( expr )\n              | tan ( expr )\n              | tanh ( expr )\n              | atan ( expr )\n              | atan2 ( exprY , exprX )\n              | hypot ( exprX , exprY )\n              | signum ( expr )\n              | rint ( expr )\n              | floor ( expr )\n              | pow[er] ( expr , expr )\n              | ceil ( expr )\n              | min ( expr1 , expr2 )\n              | max ( expr1 , expr2 )\n              | has ( variable )\n\nNotes:\n- Variables are either all alphanumeric and -/_ (e.g., \"ABc_1-2\"), any character\n  apart from \"]\" enclosed by \"[\" and \"]\" (e.g., \"[Hello World]\") or\n  enclosed by single quotes (e.g., \"'Hello World'\").\n- The 'all' method applies the value to all the values in the lookup table\n  that match the regular expression.\n- Positions are 1-based.\n- 'str' uses " + Utils.classToString(DecimalFormat.class) + " when supplying a format string\n- Variables starting with '_' (inside the [] or '') are considered local and don't get transferred back out.\n- The 'has' function checks whether a variable/symbol is present.\n";
    }

    protected String getDefaultExpression() {
        return "";
    }

    public String expressionTipText() {
        return "The lookup update rules to evaluate.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader for loading the spreadsheet to work on.";
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The input file to load with the specified reader; ignored if pointing to directory.";
    }

    public void setKeyColumn(SpreadSheetColumnIndex value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The index of the column in the spreadsheet to use as key; " + this.m_KeyColumn.getExample();
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column in the spreadsheet to use as value; " + this.m_ValueColumn.getExample();
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are used as value rather than strings.";
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    protected Object initializeSymbol(String name, String value) {
        Object result;
        try {
            result = Double.parseDouble(value);
        }
        catch (Exception e) {
            result = value;
        }
        return result;
    }

    protected SpreadSheet doEvaluate(HashMap symbols) throws Exception {
        this.m_KeyColumn.setData(this.m_Sheet);
        this.m_ValueColumn.setData(this.m_Sheet);
        return LookUpUpdate.evaluate(this.m_Expression, symbols, this.m_Sheet, this.m_KeyColumn.getIntIndex(), this.m_ValueColumn.getIntIndex());
    }

    protected void loadSheet() {
        if (this.m_Input.exists() && !this.m_Input.isDirectory()) {
            this.m_Sheet = this.m_Reader.read((File)this.m_Input);
        }
    }

    public SpreadSheet evaluate() throws Exception {
        this.loadSheet();
        return (SpreadSheet)super.evaluate();
    }

    public static HashMap spreadsheetToSymbols(SpreadSheet sheet, int keyCol, int valueCol) {
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        if (keyCol < 0) {
            throw new IllegalArgumentException("No key column specified!");
        }
        if (valueCol < 0) {
            throw new IllegalArgumentException("No value column specified!");
        }
        if (keyCol == valueCol) {
            throw new IllegalArgumentException("Key and value column are the same: " + (keyCol + 1));
        }
        if (keyCol >= sheet.getColumnCount()) {
            throw new IllegalArgumentException("Key column out of range: " + (keyCol + 1) + " > " + sheet.getColumnCount());
        }
        if (valueCol >= sheet.getColumnCount()) {
            throw new IllegalArgumentException("Value column out of range: " + (valueCol + 1) + " > " + sheet.getColumnCount());
        }
        for (Row row : sheet.rows()) {
            if (!row.hasCell(keyCol) || !row.hasCell(valueCol)) continue;
            symbols.put(row.getCell(keyCol).getContent(), row.getCell(valueCol).getNative());
        }
        return symbols;
    }

    public static SpreadSheet updateSpreadSheet(SpreadSheet sheet, int keyCol, int valueCol, HashMap updated) {
        SpreadSheet result = sheet.getClone();
        for (Object key : updated.keySet()) {
            boolean found = false;
            String keyStr = key.toString();
            if (keyStr.startsWith("_")) continue;
            for (Row row : result.rows()) {
                if (!row.hasCell(keyCol) || !row.hasCell(valueCol) || !row.getCell(keyCol).getContent().equals(keyStr)) continue;
                found = true;
                row.getCell(valueCol).setNative(updated.get(key));
                break;
            }
            if (found) continue;
            DataRow added = result.addRow();
            added.addCell(keyCol).setContentAsString(keyStr);
            added.addCell(valueCol).setNative(updated.get(key));
        }
        return result;
    }

    public static HashMap evaluate(String expr, HashMap symbols) throws Exception {
        if ((expr = expr.trim()).isEmpty()) {
            return symbols;
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        HashMap result = parser.getSymbols();
        return result;
    }

    public static SpreadSheet evaluate(String expr, HashMap symbols, SpreadSheet sheet, int keyCol, int valueCol) throws Exception {
        if ((expr = expr.trim()).isEmpty()) {
            return sheet;
        }
        symbols.putAll(LookUpUpdate.spreadsheetToSymbols(sheet, keyCol, valueCol));
        HashMap updated = LookUpUpdate.evaluate(expr, symbols);
        SpreadSheet result = LookUpUpdate.updateSpreadSheet(sheet, keyCol, valueCol, updated);
        return result;
    }

    public static void main(String[] args) {
        LookUpUpdate.runEvaluator(LookUpUpdate.class, (String[])args);
    }
}

