/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SpreadSheetColumnStatisticTest.java
 * Copyright (C) 2013-2016 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.test.TmpFile;

/**
 * Test for SpreadSheetColumnStatistic actor.
 *
 * @author fracpete
 * @author adams.core.option.FlowJUnitTestProducer (code generator)
 * @version $Revision$
 */
public class SpreadSheetColumnStatisticTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SpreadSheetColumnStatisticTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception 	if an error occurs.
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    
    m_TestHelper.copyResourceToTmp("bolts.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.csv");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  @Override
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("bolts.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    
    super.tearDown();
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
        new TmpFile[]{
          new TmpFile("dumpfile.csv")
        });
  }

  /**
   * 
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(SpreadSheetColumnStatisticTest.class);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>Actor</code> value
   */
  @Override
  public Actor getActor() {
    AbstractArgumentOption    argOption;
    
    Flow flow = new Flow();
    
    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.Actor[] actors1 = new adams.flow.core.Actor[4];

      // Flow.FileSupplier
      adams.flow.source.FileSupplier filesupplier2 = new adams.flow.source.FileSupplier();
      argOption = (AbstractArgumentOption) filesupplier2.getOptionManager().findByProperty("files");
      adams.core.io.PlaceholderFile[] files3 = new adams.core.io.PlaceholderFile[1];
      files3[0] = (adams.core.io.PlaceholderFile) argOption.valueOf("${TMP}/bolts.csv");
      filesupplier2.setFiles(files3);
      actors1[0] = filesupplier2;

      // Flow.SpreadSheetFileReader
      adams.flow.transformer.SpreadSheetFileReader spreadsheetfilereader4 = new adams.flow.transformer.SpreadSheetFileReader();
      argOption = (AbstractArgumentOption) spreadsheetfilereader4.getOptionManager().findByProperty("reader");
      adams.data.io.input.CsvSpreadSheetReader csvspreadsheetreader6 = new adams.data.io.input.CsvSpreadSheetReader();
      argOption = (AbstractArgumentOption) csvspreadsheetreader6.getOptionManager().findByProperty("spreadSheetType");
      adams.data.spreadsheet.SpreadSheet spreadsheet8 = new adams.data.spreadsheet.DefaultSpreadSheet();
      csvspreadsheetreader6.setSpreadSheetType(spreadsheet8);

      spreadsheetfilereader4.setReader(csvspreadsheetreader6);

      actors1[1] = spreadsheetfilereader4;

      // Flow.SpreadSheetColumnStatistic
      adams.flow.transformer.SpreadSheetColumnStatistic spreadsheetcolumnstatistic9 = new adams.flow.transformer.SpreadSheetColumnStatistic();
      argOption = (AbstractArgumentOption) spreadsheetcolumnstatistic9.getOptionManager().findByProperty("column");
      spreadsheetcolumnstatistic9.setColumn((adams.data.spreadsheet.SpreadSheetColumnIndex) argOption.valueOf("last"));
      argOption = (AbstractArgumentOption) spreadsheetcolumnstatistic9.getOptionManager().findByProperty("statistic");
      adams.data.spreadsheet.colstatistic.MultiColumnStatistic multicolumnstatistic12 = new adams.data.spreadsheet.colstatistic.MultiColumnStatistic();
      argOption = (AbstractArgumentOption) multicolumnstatistic12.getOptionManager().findByProperty("statistics");
      adams.data.spreadsheet.colstatistic.AbstractColumnStatistic[] statistics13 = new adams.data.spreadsheet.colstatistic.AbstractColumnStatistic[9];
      adams.data.spreadsheet.colstatistic.Min min14 = new adams.data.spreadsheet.colstatistic.Min();
      statistics13[0] = min14;
      adams.data.spreadsheet.colstatistic.Max max15 = new adams.data.spreadsheet.colstatistic.Max();
      statistics13[1] = max15;
      adams.data.spreadsheet.colstatistic.Mean mean16 = new adams.data.spreadsheet.colstatistic.Mean();
      statistics13[2] = mean16;
      adams.data.spreadsheet.colstatistic.StandardDeviation standarddeviation17 = new adams.data.spreadsheet.colstatistic.StandardDeviation();
      statistics13[3] = standarddeviation17;
      adams.data.spreadsheet.colstatistic.Median median18 = new adams.data.spreadsheet.colstatistic.Median();
      statistics13[4] = median18;
      adams.data.spreadsheet.colstatistic.IQR iqr19 = new adams.data.spreadsheet.colstatistic.IQR();
      statistics13[5] = iqr19;
      adams.data.spreadsheet.colstatistic.Distinct distinct20 = new adams.data.spreadsheet.colstatistic.Distinct();
      statistics13[6] = distinct20;
      adams.data.spreadsheet.colstatistic.Unique unique21 = new adams.data.spreadsheet.colstatistic.Unique();
      statistics13[7] = unique21;
      adams.data.spreadsheet.colstatistic.Missing missing22 = new adams.data.spreadsheet.colstatistic.Missing();
      statistics13[8] = missing22;
      multicolumnstatistic12.setStatistics(statistics13);

      spreadsheetcolumnstatistic9.setStatistic(multicolumnstatistic12);

      actors1[2] = spreadsheetcolumnstatistic9;

      // Flow.DumpFile
      adams.flow.sink.DumpFile dumpfile23 = new adams.flow.sink.DumpFile();
      argOption = (AbstractArgumentOption) dumpfile23.getOptionManager().findByProperty("outputFile");
      dumpfile23.setOutputFile((adams.core.io.PlaceholderFile) argOption.valueOf("${TMP}/dumpfile.csv"));
      actors1[3] = dumpfile23;
      flow.setActors(actors1);

      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("flowExecutionListener");
      adams.flow.execution.NullListener nulllistener26 = new adams.flow.execution.NullListener();
      flow.setFlowExecutionListener(nulllistener26);

    }
    catch (Exception e) {
      fail("Failed to set up actor: " + e);
    }
    
    return flow;
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}

