/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.RowArrayToSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RowArrayToSpreadSheetTest
extends AbstractConversionTestCase {
    public RowArrayToSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Row[][] result;
        TmpFile file = new TmpFile("labor.csv");
        try {
            SpreadSheet data = new CsvSpreadSheetReader().read((File)file);
            result = new Row[][]{data.rows().toArray(new Row[0])};
        }
        catch (Exception e) {
            result = new Row[][]{};
            RowArrayToSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        RowArrayToSpreadSheet[] result = new RowArrayToSpreadSheet[]{new RowArrayToSpreadSheet()};
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(RowArrayToSpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RowArrayToSpreadSheetTest.runTest((Test)RowArrayToSpreadSheetTest.suite());
    }
}

