/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.TransposeSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TransposeSpreadSheetTest
extends AbstractConversionTestCase {
    public TransposeSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("simple.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("simple.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("simple.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            TransposeSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        TransposeSpreadSheet[] result = new TransposeSpreadSheet[4];
        result[0] = new TransposeSpreadSheet();
        result[1] = new TransposeSpreadSheet();
        result[1].setUseFirstColumnAsHeader(true);
        result[2] = new TransposeSpreadSheet();
        result[2].setUseHeaderAsFirstColumn(true);
        result[3] = new TransposeSpreadSheet();
        result[3].setUseFirstColumnAsHeader(true);
        result[3].setUseHeaderAsFirstColumn(true);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(TransposeSpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TransposeSpreadSheetTest.runTest((Test)TransposeSpreadSheetTest.suite());
    }
}

