/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractCellFinderTestCase
extends AdamsTestCase {
    public AbstractCellFinderTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/cellfinder/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract CellFinder[] getRegressionSetups();

    protected CellLocation[] process(SpreadSheet data, CellFinder scheme) {
        Iterator iter = scheme.findCells(data);
        ArrayList<CellLocation> result = new ArrayList<CellLocation>();
        while (iter.hasNext()) {
            result.add((CellLocation)iter.next());
        }
        return result.toArray(new CellLocation[result.size()]);
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    protected boolean save(CellLocation[] data, String filename) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < data.length; ++i) {
            list.add(data[i].toString());
        }
        return FileUtils.saveToFile(list, (File)new TmpFile(filename));
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        CellFinder[] setups = this.getRegressionSetups();
        AbstractCellFinderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractCellFinderTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            CellFinder current = (CellFinder)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractCellFinderTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            CellLocation[] processed = this.process(data, current);
            AbstractCellFinderTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractCellFinderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            ((Destroyable)current).destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractCellFinderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

