/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.filter;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.filter.SpreadSheetFilter;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractSpreadSheetFilterTestCase
extends AdamsTestCase {
    public AbstractSpreadSheetFilterTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/filter/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract SpreadSheetFilter[] getRegressionSetups();

    protected SpreadSheet process(SpreadSheet data, SpreadSheetFilter scheme) throws Exception {
        return scheme.filter(data);
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    protected boolean save(SpreadSheet data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data);
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        SpreadSheetFilter[] setups = this.getRegressionSetups();
        AbstractSpreadSheetFilterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet processed;
            SpreadSheet data = this.load(input[i]);
            AbstractSpreadSheetFilterTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            SpreadSheetFilter current = (SpreadSheetFilter)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractSpreadSheetFilterTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            try {
                processed = this.process(data, current);
                AbstractSpreadSheetFilterTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            }
            catch (Exception e) {
                processed = null;
                AbstractSpreadSheetFilterTestCase.fail((String)LoggingHelper.throwableToString((Throwable)e));
            }
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractSpreadSheetFilterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            ((Destroyable)current).destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractSpreadSheetFilterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

