/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractRowScoreTestCase
extends AdamsTestCase {
    public AbstractRowScoreTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/rowscore/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractRowScore[] getRegressionSetups();

    protected abstract int[] getRegressionRows();

    protected Double[] process(SpreadSheet data, int row, AbstractRowScore scheme) {
        return scheme.calculateScore(data, row);
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    protected boolean save(Double[] data, String filename) {
        Object dataStr;
        if (data == null) {
            dataStr = "" + data;
        } else {
            dataStr = "";
            for (int i = 0; i < data.length; ++i) {
                if (i > 0) {
                    dataStr = (String)dataStr + ",";
                }
                dataStr = (String)dataStr + Utils.doubleToStringFixed((double)data[i], (int)6);
            }
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)dataStr, (boolean)false);
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractRowScore[] setups = this.getRegressionSetups();
        int[] rows = this.getRegressionRows();
        AbstractRowScoreTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        AbstractRowScoreTestCase.assertEquals((String)"Number of setups and rows differ!", (int)setups.length, (int)rows.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractRowScoreTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractRowScore current = (AbstractRowScore)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractRowScoreTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            Double[] processed = this.process(data, rows[i], current);
            AbstractRowScoreTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractRowScoreTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractRowScoreTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

