/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.AbstractBooleanConditionTestCase;
import adams.flow.condition.bool.HasRows;
import adams.flow.core.Actor;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class HasRowsTest
extends AbstractBooleanConditionTestCase {
    public HasRowsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        super.tearDown();
    }

    protected Actor[] getRegressionOwners() {
        return new Actor[]{null, null, null};
    }

    protected Object[] getRegressionInputs() {
        TmpFile file = new TmpFile("bolts.csv");
        try {
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            SpreadSheet sheet = reader.read((File)file);
            return new SpreadSheet[]{sheet, sheet, sheet};
        }
        catch (Exception e) {
            HasRowsTest.fail((String)("Failed to load file: " + file));
            return null;
        }
    }

    protected AbstractBooleanCondition[] getRegressionSetups() {
        HasRows[] result = new HasRows[3];
        result[0] = new HasRows();
        result[1] = new HasRows();
        result[1].setMinRows(0);
        result[2] = new HasRows();
        result[2].setMinRows(100);
        return result;
    }

    public static Test suite() {
        return new TestSuite(HasRowsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        HasRowsTest.runTest((Test)HasRowsTest.suite());
    }
}

