/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.AnyToString;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetCellLocationToCoordinates;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.RowFinderRange;
import adams.data.spreadsheet.rowfinder.ByNumericValue;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.GetArrayElement;
import adams.flow.transformer.SpreadSheetCellFinder;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.StringJoin;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetCellFinderTest
extends AbstractFlowTest {
    public SpreadSheetCellFinderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetCellFinderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((SpreadSheet)defaultspreadsheet);
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors.add(spreadsheetfilereader);
            SpreadSheetCellFinder spreadsheetcellfinder = new SpreadSheetCellFinder();
            spreadsheetcellfinder.setOutputArray(true);
            RowFinderRange rowfinderrange = new RowFinderRange();
            ByNumericValue bynumericvalue = new ByNumericValue();
            argOption = (AbstractArgumentOption)bynumericvalue.getOptionManager().findByProperty("attributeIndex");
            bynumericvalue.setAttributeIndex((SpreadSheetColumnIndex)argOption.valueOf("TIME"));
            argOption = (AbstractArgumentOption)bynumericvalue.getOptionManager().findByProperty("minimum");
            bynumericvalue.setMinimum(((Double)argOption.valueOf("50.0")).doubleValue());
            bynumericvalue.setMinimumIncluded(true);
            argOption = (AbstractArgumentOption)bynumericvalue.getOptionManager().findByProperty("maximum");
            bynumericvalue.setMaximum(((Double)argOption.valueOf("NaN")).doubleValue());
            rowfinderrange.setRowFinder((RowFinder)bynumericvalue);
            argOption = (AbstractArgumentOption)rowfinderrange.getOptionManager().findByProperty("columns");
            rowfinderrange.setColumns((SpreadSheetColumnRange)argOption.valueOf("TIME"));
            spreadsheetcellfinder.setFinder((CellFinder)rowfinderrange);
            actors.add(spreadsheetcellfinder);
            ArrayProcess arrayprocess = new ArrayProcess();
            ArrayList<Object> actors2 = new ArrayList<Object>();
            Convert convert = new Convert();
            SpreadSheetCellLocationToCoordinates celltocoords = new SpreadSheetCellLocationToCoordinates();
            convert.setConversion((Conversion)celltocoords);
            actors2.add(convert);
            GetArrayElement getelem = new GetArrayElement();
            actors2.add(getelem);
            Convert convert2 = new Convert();
            AnyToString anytostring = new AnyToString();
            convert2.setConversion((Conversion)anytostring);
            actors2.add(convert2);
            arrayprocess.setActors(actors2.toArray(new Actor[0]));
            actors.add(arrayprocess);
            StringJoin stringjoin = new StringJoin();
            argOption = (AbstractArgumentOption)stringjoin.getOptionManager().findByProperty("glue");
            stringjoin.setGlue((String)argOption.valueOf(","));
            actors.add(stringjoin);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SpreadSheetCellFinderTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetCellFinderTest.runTest((Test)SpreadSheetCellFinderTest.suite());
    }
}

