/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetQuery;
import adams.parser.SpreadSheetQueryText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetQueryTest
extends AbstractFlowTest {
    public SpreadSheetQueryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetQueryTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] actors1 = new Actor[4];
            FileSupplier filesupplier2 = new FileSupplier();
            argOption = (AbstractArgumentOption)filesupplier2.getOptionManager().findByProperty("files");
            PlaceholderFile[] files3 = new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv")};
            filesupplier2.setFiles(files3);
            actors1[0] = filesupplier2;
            SpreadSheetFileReader spreadsheetfilereader4 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)spreadsheetfilereader4.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader csvspreadsheetreader6 = new CsvSpreadSheetReader();
            spreadsheetfilereader4.setReader((SpreadSheetReader)csvspreadsheetreader6);
            actors1[1] = spreadsheetfilereader4;
            SpreadSheetQuery spreadsheetquery7 = new SpreadSheetQuery();
            argOption = (AbstractArgumentOption)spreadsheetquery7.getOptionManager().findByProperty("query");
            spreadsheetquery7.setQuery((SpreadSheetQueryText)argOption.valueOf("SELECT RUN,SPEED1 AS SPEED,SENS AS SENSOR,TIME,T20BOLT AS CLASS\nWHERE (SPEED1 < 6)\nAND (RUN >= 10)\nORDER BY CLASS"));
            actors1[2] = spreadsheetquery7;
            DumpFile dumpfile9 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile9.getOptionManager().findByProperty("outputFile");
            dumpfile9.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            actors1[3] = dumpfile9;
            flow.setActors(actors1);
            argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("flowExecutionListener");
            NullListener nulllistener12 = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener12);
        }
        catch (Exception e) {
            SpreadSheetQueryTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetQueryTest.runTest((Test)SpreadSheetQueryTest.suite());
    }
}

