/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.base.BaseString;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.AbstractSymbolEvaluatorTestCase;
import adams.parser.LookUpUpdate;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class LookUpUpdateTest
extends AbstractSymbolEvaluatorTestCase<Double, LookUpUpdate> {
    protected SpreadSheet m_Sheet;

    public LookUpUpdateTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "lookup2.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        this.m_TestHelper.deleteFileFromTmp(filename);
    }

    protected BaseString[][][] getRegressionSymbols() {
        return new BaseString[][][]{{new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], {new BaseString("_Hello World=1")}, {new BaseString("Hello World=1")}, {new BaseString("Hello World=9.9")}, {new BaseString("_Hello World=9.9")}, {new BaseString("_Hello World=9.9")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, new BaseString[0], new BaseString[0], {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_var=some string")}, {new BaseString("_num=1.234")}}};
    }

    protected String[][] getRegressionExpressions() {
        return new String[][]{{"", "if (C = 2) then C := A * B; end", "if (C = 3) then C := A * B + 0.1; else C := A + 10; end", "C := 5;", "if (C = 2) then C := A * B + 0.1; E := \"A*B+0.1\"; else C := A + 10; E := \"A+10\"; end", "if (C = 2) then C := A * B + 0.1; end D := 0.5; E := \"updated\";", "all(\".*\") := 0.33;", "C := -5;", "if (C = 2) then all(\".*\") := 0.12; else all(\".*\") := 0.78; end", "if ([_Hello World] = 1) then C := 1.3; end", "if ('Hello World' = 1) then C := 4.5; end", "C := [Hello World];", "C := '_Hello World';", "C := has('_Hello World');", "if (_var = \"some string\") then C := -1.0; end", "if (_var != \"some string\") then C := -1.0; end", "if (matches(_var, \"^.*ome str.*$\")) then C := -1.0; end", "if (substr(_var, 4) == \"e string\") then C := -1.0; end", "if (left(_var, 4) == \"some\") then C := -1.0; end", "if (right(_var, 4) == \"ring\") then C := -1.0; end", "if (mid(_var, 4, 4) == \"e st\") then C := -1.0; end", "_v := trim(rept(\" Yo \", 3)); C := _v;", "_v := trim(rept(\" Yo \", 3)); C := len(_v);", "C := find(\"str\", _var);", "C := contains(_var, \"str\");", "C := replace(_var, 3, 5, \"STR\");", "C := replaceall(_var, \"s[ot]\", \"S.\");", "C := substitute(_var, \"s\", \"S\");", "C := concatenate(str(_num, 1), \" \", str(_num, 3));"}};
    }

    protected Object[] process(String[] expressions, BaseString[][] symbols, LookUpUpdate scheme) {
        scheme.setSheet(this.m_Sheet);
        return super.process(expressions, symbols, (AbstractSymbolEvaluator)scheme);
    }

    protected LookUpUpdate[] getRegressionSetups() {
        LookUpUpdate[] result = new LookUpUpdate[]{new LookUpUpdate()};
        result[0].setKeyColumn(new SpreadSheetColumnIndex("1"));
        result[0].setValueColumn(new SpreadSheetColumnIndex("2"));
        return result;
    }

    public static Test suite() {
        return new TestSuite(LookUpUpdateTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        LookUpUpdateTest.runTest((Test)LookUpUpdateTest.suite());
    }
}

