/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

public class RowArrayToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 8437314873901704106L;

    public String globalInfo() {
        return "Converts an array of spreadsheet rows into a single spreadsheet.";
    }

    public Class accepts() {
        return Row[].class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Row[] rows = (Row[])this.m_Input;
        if (rows.length == 0) {
            throw new IllegalStateException("Empty Row array!");
        }
        SpreadSheet result = rows[0].getOwner().getHeader();
        for (Row row : rows) {
            result.addRow().assign(row);
        }
        return result;
    }
}

