/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class SpreadSheetAddRowID
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = -6368389681769797003L;
    protected String m_Header;
    protected SpreadSheetColumnIndex m_Position;
    protected boolean m_After;
    protected int m_Start;

    public String globalInfo() {
        return "Adds an ID column to the spreadsheet, using the row index as value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("header", "header", (Object)"ID");
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("start", "start", (Object)1);
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnIndex();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"header", (Object)("'" + this.m_Header + "'"), (String)"header: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? (String)result + ", at/after: " : (this.m_After ? (String)result + ", after: " : (String)result + ", at: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"start", (Object)this.m_Start, (String)", start: ");
        return result;
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the new column.";
    }

    public void setPosition(SpreadSheetColumnIndex value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the ID column.";
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the ID column is inserted after the position instead of at the position.";
    }

    public void setStart(int value) {
        this.m_Start = value;
        this.reset();
    }

    public int getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The first ID to use.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Position.setSpreadSheet(result);
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        result.insertColumn(pos, this.m_Header);
        for (int i = 0; i < result.getRowCount(); ++i) {
            DataRow row = result.getRow(i);
            row.getCell(pos).setContent(Integer.valueOf(this.m_Start + i));
        }
        return result;
    }
}

