/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.data.spreadsheet.columnfinder.NullFinder;

public class SpreadSheetColumnFinderToRange
extends AbstractConversion {
    private static final long serialVersionUID = 4117708470154504868L;
    protected ColumnFinder m_ColumnFinder;
    protected boolean m_IndividualIndices;
    protected String m_IndexSeparator;

    public String globalInfo() {
        return "Turns the columns that the specified column finder locates into a 1-based range string. Instead of a compressed range string (eg 1-4) it is also possible to output the individual indices (eg 1,2,3,4).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-finder", "columnFinder", (Object)new NullFinder());
        this.m_OptionManager.add("individual-indices", "individualIndices", (Object)false);
        this.m_OptionManager.add("index-separator", "indexSeparator", (Object)",");
    }

    public void setColumnFinder(ColumnFinder value) {
        this.m_ColumnFinder = value;
        this.reset();
    }

    public ColumnFinder getColumnFinder() {
        return this.m_ColumnFinder;
    }

    public String columnFinderTipText() {
        return "The column finder to use.";
    }

    public void setIndividualIndices(boolean value) {
        this.m_IndividualIndices = value;
        this.reset();
    }

    public boolean getIndividualIndices() {
        return this.m_IndividualIndices;
    }

    public String individualIndicesTipText() {
        return "If enabled then individual indices (1,2,3,4) are output instead of compressed ranges (1-4).";
    }

    public void setIndexSeparator(String value) {
        if (value.length() > 0) {
            this.m_IndexSeparator = value;
            this.reset();
        } else {
            this.getLogger().warning("Index separator cannot be empty!");
        }
    }

    public String getIndexSeparator() {
        return this.m_IndexSeparator;
    }

    public String indexSeparatorTipText() {
        return "The separator to use when outputting individual indices, eg comma or blank.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"columnFinder", (Object)this.m_ColumnFinder, (String)"column finder: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"individualIndices", (Object)(this.m_IndividualIndices ? "indices" : "range"), (String)", type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"indexSeparator", (Object)("'" + this.m_IndexSeparator + "'"), (String)", separator: ");
        return result;
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        String result;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        int[] columns = this.m_ColumnFinder.findColumns(sheet);
        if (this.m_IndividualIndices) {
            StringBuilder indices = new StringBuilder();
            for (int index : columns) {
                if (indices.length() > 0) {
                    indices.append(this.m_IndexSeparator);
                }
                indices.append("" + (index + 1));
            }
            result = indices.toString();
        } else {
            Range range = new Range();
            range.setIndices(columns);
            result = range.getRange();
        }
        return result;
    }
}

