/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;
import adams.data.spreadsheet.SpreadSheetUtils;

public class SpreadSheetInsertColumnPosition
extends AbstractStringConversion {
    private static final long serialVersionUID = 3314208609415992655L;
    protected String m_Placeholder;
    protected int m_Column;

    public String globalInfo() {
        return "Replaces the specified placeholder with a column string (e.g., BG) generated from the user-supplied column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("placeholder", "placeholder", (Object)"{C}");
        this.m_OptionManager.add("column", "column", (Object)1, (Number)1, null);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"placeholder", (Object)this.m_Placeholder, (String)"placeholder: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)this.m_Column, (String)", col: ");
        return result;
    }

    public void setPlaceholder(String value) {
        if (value.length() > 0) {
            this.m_Placeholder = value;
            this.reset();
        } else {
            this.getLogger().severe("The placeholder cannot be an empty string!");
        }
    }

    public String getPlaceholder() {
        return this.m_Placeholder;
    }

    public String placeholderTipText() {
        return "The placeholder to replace in the string with the generated cell location.";
    }

    public void setColumn(int value) {
        if (value > 0) {
            this.m_Column = value;
            this.reset();
        } else {
            this.getLogger().severe("Column index must be greater than 0, provided: " + value);
        }
    }

    public int getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The 1-based column index to use for the cell location.";
    }

    protected Object doConvert() throws Exception {
        String cell = SpreadSheetUtils.getColumnPosition((int)(this.m_Column - 1));
        String result = ((String)this.m_Input).replace(this.m_Placeholder, cell);
        return result;
    }
}

