/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.transformer.StringSplit;

public class SpreadSheetSplitColumn
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = 6146479838753681459L;
    protected SpreadSheetColumnIndex m_Column;
    protected String m_Expression;
    protected StringSplit.Delimiter m_Delimiter;

    public String globalInfo() {
        return "Splits the string representation of the cells of a column into multiple columns using a regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("expression", "expression", (Object)"\\t");
        this.m_OptionManager.add("delimiter", "delimiter", (Object)StringSplit.Delimiter.DISCARD);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)this.m_Column.getIndex(), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"expression", (Object)(this.m_Expression.isEmpty() ? "-none-" : Utils.backQuoteChars((String)this.m_Expression)), (String)", expr: ");
        result = (String)result + "(" + QuickInfoHelper.toString((OptionHandler)this, (String)"delimiter", (Object)this.m_Delimiter) + ")";
        return result;
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to split.";
    }

    public void setExpression(String value) {
        this.m_Expression = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getExpression() {
        return Utils.backQuoteChars((String)this.m_Expression);
    }

    public String expressionTipText() {
        return "The regular expression used for splitting the column; \\t\\n\\r\\b\\f get automatically converted into their character counterparts.";
    }

    public void setDelimiter(StringSplit.Delimiter value) {
        this.m_Delimiter = value;
        this.reset();
    }

    public StringSplit.Delimiter getDelimiter() {
        return this.m_Delimiter;
    }

    public String delimiterTipText() {
        return "Defines what to do with the delimiters (= expression).";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        int i;
        int n;
        int r;
        this.m_Column.setSpreadSheet(input);
        int col = this.m_Column.getIntIndex();
        int num = 0;
        String[][] split = new String[input.getRowCount()][];
        for (r = 0; r < split.length; ++r) {
            String str;
            Cell cell = input.getCell(r, col);
            if (cell == null || cell.isMissing() || (str = cell.getContent()) == null) continue;
            split[r] = str.split(this.m_Expression);
            if (split[r].length <= num) continue;
            num = split[r].length;
        }
        HeaderRow rowIn = input.getHeaderRow();
        String[] header = rowIn.getCell(col).getContent().split(this.m_Expression);
        if (header.length != num) {
            header = new String[num];
            for (n = 0; n < num; ++n) {
                header[n] = rowIn.getCell(col).getContent() + "-" + (n + 1);
            }
        }
        SpreadSheet result = input.newInstance();
        result.setDataRowClass(input.getDataRowClass());
        rowIn = input.getHeaderRow();
        HeaderRow rowOut = result.getHeaderRow();
        for (i = 0; i < input.getColumnCount(); ++i) {
            if (i == col) {
                for (n = 0; n < num; ++n) {
                    rowOut.addCell("" + rowOut.getCellCount()).setContent(header[n]);
                }
                continue;
            }
            rowOut.addCell("" + rowOut.getCellCount()).assign(rowIn.getCell(i));
        }
        for (r = 0; r < input.getRowCount(); ++r) {
            rowIn = input.getRow(r);
            rowOut = result.addRow();
            int cindex = 0;
            for (i = 0; i < input.getColumnCount(); ++i) {
                if (!rowIn.hasCell(i) || rowIn.getCell(i).isMissing()) continue;
                if (i == col) {
                    if (split[r] == null || split[r].length == 0) continue;
                    for (n = 0; n < split[r].length; ++n) {
                        rowOut.addCell(cindex + n).setContent(split[r][n]);
                    }
                    cindex += num;
                    continue;
                }
                rowOut.addCell(cindex).assign(rowIn.getCell(i));
                ++cindex;
            }
        }
        return result;
    }
}

