/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class SpreadSheetToCreateTableStatement
extends AbstractConversion {
    private static final long serialVersionUID = 4890225060389916155L;
    protected String m_TableName;
    protected SpreadSheetColumnIndex m_NameColumn;
    protected SpreadSheetColumnIndex m_TypeColumn;
    protected SpreadSheetColumnIndex m_IndexColumn;

    public String globalInfo() {
        return "Turns a spreadsheet into a SQL 'CREATE TABLE' statement.\nRequires two columns: column names, SQL column types.\nAn optional 3rd column can be used to indicate whether a column is to be used as an index (boolean).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("table-name", "tableName", (Object)"newtable");
        this.m_OptionManager.add("name-column", "nameColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("type-column", "typeColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("index-column", "indexColumn", (Object)new SpreadSheetColumnIndex("3"));
    }

    public void setTableName(String value) {
        this.m_TableName = value;
        this.reset();
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public String tableNameTipText() {
        return "The name of the table.";
    }

    public void setNameColumn(SpreadSheetColumnIndex value) {
        this.m_NameColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getNameColumn() {
        return this.m_NameColumn;
    }

    public String nameColumnTipText() {
        return "The column in the spreadsheet that holds the name of the table columns.";
    }

    public void setTypeColumn(SpreadSheetColumnIndex type) {
        this.m_TypeColumn = type;
        this.reset();
    }

    public SpreadSheetColumnIndex getTypeColumn() {
        return this.m_TypeColumn;
    }

    public String typeColumnTipText() {
        return "The column in the spreadsheet that holds the SQL types for the table columns.";
    }

    public void setIndexColumn(SpreadSheetColumnIndex index) {
        this.m_IndexColumn = index;
        this.reset();
    }

    public SpreadSheetColumnIndex getIndexColumn() {
        return this.m_IndexColumn;
    }

    public String indexColumnTipText() {
        return "The column in the spreadsheet that indicates whether a column should be an index.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        StringBuilder result = new StringBuilder();
        StringBuilder index = new StringBuilder();
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_NameColumn.setData(sheet);
        int colName = this.m_NameColumn.getIntIndex();
        if (colName == -1) {
            throw new Exception("Name column '" + this.m_NameColumn + "' not found!");
        }
        this.m_TypeColumn.setData(sheet);
        int colType = this.m_TypeColumn.getIntIndex();
        if (colType == -1) {
            throw new Exception("Type column '" + this.m_TypeColumn + "' not found!");
        }
        this.m_IndexColumn.setData(sheet);
        int colIndex = this.m_IndexColumn.getIntIndex();
        result.append("CREATE TABLE " + this.m_TableName + " (");
        boolean first = true;
        for (Row row : sheet.rows()) {
            if (!row.hasCell(colName) || row.getCell(colName).isMissing() || !row.hasCell(colType) || row.getCell(colType).isMissing()) continue;
            if (!first) {
                result.append(",");
            }
            result.append("\n");
            result.append("  ").append(row.getCell(colName).getContent());
            result.append(" ").append(row.getCell(colType).getContent());
            if (colIndex > -1 && row.hasCell(colIndex) && !row.getCell(colIndex).isMissing()) {
                index.append("CREATE INDEX ");
                index.append(this.m_TableName.toLowerCase()).append("_idx_").append(row.getCell(colName).getContent().toLowerCase());
                index.append(" ON ").append(this.m_TableName);
                index.append(" (").append(row.getCell(colName).getContent()).append(");\n");
            }
            first = false;
        }
        result.append("\n);");
        if (index.length() > 0) {
            result.append("\n").append(index.toString());
        }
        return result;
    }
}

