/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.BaseClassname;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import java.util.HashMap;
import java.util.Map;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetToMap
extends AbstractConversion {
    private static final long serialVersionUID = 4890225060389916155L;
    protected SpreadSheetColumnIndex m_KeyColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;
    protected BaseClassname m_MapClass;

    public String globalInfo() {
        return "Turns two columns (key and value) of a spreadsheet into a map object of the specified type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("map-class", "mapClass", (Object)new BaseClassname(HashMap.class));
    }

    public void setKeyColumn(SpreadSheetColumnIndex value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The column in the spreadsheet to act as the 'key' for the values.";
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The column in the spreadsheet to stores the 'values'.";
    }

    public void setMapClass(BaseClassname value) {
        if (ClassLocator.hasInterface(Map.class, (Class)value.classValue())) {
            this.m_MapClass = value;
            this.reset();
        } else {
            this.getLogger().warning("Class '" + value + "' does not implement the '" + Map.class.getName() + "' interface!");
        }
    }

    public BaseClassname getMapClass() {
        return this.m_MapClass;
    }

    public String mapClassTipText() {
        return "The type of map to instantiate and fill.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return this.m_MapClass.classValue();
    }

    protected Object doConvert() throws Exception {
        Map result = (Map)this.m_MapClass.classValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_KeyColumn.setData(sheet);
        int colKey = this.m_KeyColumn.getIntIndex();
        if (colKey == -1) {
            throw new Exception("Key column '" + this.m_KeyColumn + "' not found!");
        }
        this.m_ValueColumn.setData(sheet);
        int colValue = this.m_ValueColumn.getIntIndex();
        if (colValue == -1) {
            throw new Exception("Value column '" + this.m_ValueColumn + "' not found!");
        }
        for (Row row : sheet.rows()) {
            if (!row.hasCell(colKey) || row.getCell(colKey).isMissing() || !row.hasCell(colValue) || row.getCell(colValue).isMissing()) continue;
            result.put(row.getCell(colKey).getNative(), row.getCell(colValue).getNative());
        }
        return result;
    }
}

