/*
 * Decompiled with CFR 0.152.
 */
package adams.data.groupextraction;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.groupextraction.AbstractGroupExtractor;
import adams.data.groupextraction.SpreadSheetRowGroupExtractorWithColumn;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class SpreadSheetCellRegExp
extends AbstractGroupExtractor
implements SpreadSheetRowGroupExtractorWithColumn {
    private static final long serialVersionUID = 6130414784797102811L;
    protected SpreadSheetColumnIndex m_Column;
    protected BaseRegExp m_RegExp;
    protected String m_Group;

    public String globalInfo() {
        return "Applies regular expression to the cell value of the spreadsheet row and returns the specified expression group.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp("(.*)"));
        this.m_OptionManager.add("group", "group", (Object)"$1");
    }

    @Override
    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    @Override
    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    @Override
    public String columnTipText() {
        return "The column of the cell to get the group from.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to apply to the cell value.";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The group of the expression to extract.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col:");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", regexp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"group", (Object)this.m_Group, (String)", group: ");
        return result;
    }

    public boolean handles(Object obj) {
        return obj instanceof Row;
    }

    protected String doExtractGroup(Object obj) {
        String result = null;
        Row row = (Row)obj;
        this.m_Column.setSpreadSheet(row.getOwner());
        if (this.m_Column.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate column: " + this.m_Column);
        }
        String value = null;
        Cell cell = row.getCell(this.m_Column.getIntIndex());
        if (cell != null && !cell.isMissing()) {
            value = cell.getContent();
        }
        if (value != null) {
            result = value.replaceAll(this.m_RegExp.getValue(), this.m_Group);
        }
        return result;
    }
}

