/*
 * Decompiled with CFR 0.152.
 */
package adams.data.idextraction;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.idextraction.AbstractIDExtractor;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class SpreadSheetCell
extends AbstractIDExtractor {
    private static final long serialVersionUID = 6130414784797102811L;
    protected SpreadSheetColumnIndex m_Column;

    public String globalInfo() {
        return "Returns the value of the specified cell of the spreadsheet row coming through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the cell to get the ID from.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column));
    }

    public boolean handles(Object obj) {
        return obj instanceof Row;
    }

    protected String doExtractID(Object obj) {
        Row row = (Row)obj;
        this.m_Column.setSpreadSheet(row.getOwner());
        if (this.m_Column.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate column: " + this.m_Column);
        }
        Cell cell = row.getCell(this.m_Column.getIntIndex());
        if (cell != null && !cell.isMissing()) {
            return cell.getContent();
        }
        return null;
    }
}

