/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.BasicDateTimeType;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.DateFormatString;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.output.AutoWidthTabularSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Locale;
import java.util.TimeZone;

public class AutoWidthTabularSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport
implements OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = 7625761549460086503L;
    protected int m_MinSpaces;
    protected Range m_TextColumns;
    protected Range m_DateTimeColumns;
    protected DateFormatString m_DateTimeFormat;
    protected boolean m_DateTimeLenient;
    protected BasicDateTimeType m_DateTimeType;
    protected TimeZone m_TimeZone;
    protected Locale m_Locale;
    protected boolean m_Trim;

    public String globalInfo() {
        return "Reads simple tabular text files, using column widths as defined by the header row.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("min-spaces", "minSpaces", (Object)1, (Number)1, null);
        this.m_OptionManager.add("trim", "trim", (Object)true);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-columns", "dateTimeColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("datetime-lenient", "dateTimeLenient", (Object)false);
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)BasicDateTimeType.DATE_TIME);
    }

    protected BaseRegExp getDefaultMissingValue() {
        return new BaseRegExp("");
    }

    public void setMinSpaces(int value) {
        this.m_MinSpaces = value;
        this.reset();
    }

    public int getMinSpaces() {
        return this.m_MinSpaces;
    }

    public String minSpacesTipText() {
        return "The minimum number of spaces between columns.";
    }

    public void setTextColumns(Range value) {
        this.m_TextColumns = value;
        this.reset();
    }

    public Range getTextColumns() {
        return this.m_TextColumns;
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text.";
    }

    public void setDateTimeColumns(Range value) {
        this.m_DateTimeColumns = value;
        this.reset();
    }

    public Range getDateTimeColumns() {
        return this.m_DateTimeColumns;
    }

    public String dateTimeColumnsTipText() {
        return "The range of columns to treat as date/time msec.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/time msecs.";
    }

    public void setDateTimeLenient(boolean value) {
        this.m_DateTimeLenient = value;
        this.reset();
    }

    public boolean isDateTimeLenient() {
        return this.m_DateTimeLenient;
    }

    public String dateTimeLenientTipText() {
        return "Whether date/time msec parsing is lenient or not.";
    }

    public void setDateTimeType(BasicDateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public BasicDateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "How to interpret the date/time data.";
    }

    public void setTimeZone(TimeZone value) {
        this.m_TimeZone = value;
        this.reset();
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public String timeZoneTipText() {
        return "The time zone to use for interpreting dates/times; default is the system-wide defined one.";
    }

    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String localeTipText() {
        return "The locale to use for parsing the numbers.";
    }

    public void setTrim(boolean value) {
        this.m_Trim = value;
        this.reset();
    }

    public boolean getTrim() {
        return this.m_Trim;
    }

    public String trimTipText() {
        return "If enabled, the content of the cells gets trimmed before added.";
    }

    public String getFormatDescription() {
        return "Auto-width tabular format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"txt", "txt.gz"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new AutoWidthTabularSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    protected boolean supportsCompressedInput() {
        return true;
    }

    protected int[] determineColStarts(String header, int minSpaces) {
        TIntArrayList starts = new TIntArrayList();
        if (header.length() > 0) {
            int i;
            boolean isHeader;
            TIntArrayList ends = new TIntArrayList();
            boolean bl = isHeader = header.charAt(0) != ' ';
            if (isHeader) {
                starts.add(0);
            }
            for (i = 1; i < header.length(); ++i) {
                if (header.charAt(i) == ' ') {
                    if (!isHeader) continue;
                    ends.add(i - 1);
                    isHeader = false;
                    continue;
                }
                if (isHeader) continue;
                starts.add(i);
                isHeader = true;
            }
            if (minSpaces > 1) {
                i = 1;
                while (i < starts.size()) {
                    if (starts.get(i) - ends.get(i - 1) - 1 < minSpaces) {
                        starts.removeAt(i);
                        ends.removeAt(i - 1);
                        continue;
                    }
                    ++i;
                }
            }
        }
        return starts.toArray();
    }

    protected SpreadSheet doRead(Reader r) {
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        boolean first = true;
        int[] colStarts = new int[]{};
        String[] cells = new String[]{};
        Cell.ContentType[] types = new Cell.ContentType[]{};
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                HeaderRow row;
                int i;
                if (first) {
                    colStarts = this.determineColStarts(line, this.m_MinSpaces);
                    cells = new String[colStarts.length];
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Column starts: " + Utils.arrayToString((Object)colStarts));
                    }
                    types = new Cell.ContentType[colStarts.length];
                    this.m_TextColumns.setMax(colStarts.length);
                    this.m_DateTimeColumns.setMax(colStarts.length);
                    block14: for (i = 0; i < colStarts.length; ++i) {
                        types[i] = null;
                        if (this.m_TextColumns.isInRange(i)) {
                            types[i] = Cell.ContentType.STRING;
                            continue;
                        }
                        if (!this.m_DateTimeColumns.isInRange(i)) continue;
                        switch (this.m_DateTimeType) {
                            case TIME: {
                                types[i] = Cell.ContentType.TIME;
                                continue block14;
                            }
                            case TIME_MSEC: {
                                types[i] = Cell.ContentType.TIMEMSEC;
                                continue block14;
                            }
                            case DATE: {
                                types[i] = Cell.ContentType.DATE;
                                continue block14;
                            }
                            case DATE_TIME: {
                                types[i] = Cell.ContentType.DATETIME;
                                continue block14;
                            }
                            case DATE_TIME_MSEC: {
                                types[i] = Cell.ContentType.DATETIMEMSEC;
                                continue block14;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled date/time type: " + this.m_DateTimeType);
                            }
                        }
                    }
                }
                for (i = 0; i < colStarts.length; ++i) {
                    int start = colStarts[i];
                    int end = i == colStarts.length - 1 ? line.length() : colStarts[i + 1];
                    if (end >= line.length()) {
                        end = line.length();
                    }
                    cells[i] = start >= line.length() ? "" : line.substring(start, end);
                    if (!this.m_Trim) continue;
                    cells[i] = cells[i].trim();
                }
                if (first) {
                    row = result.getHeaderRow();
                    for (i = 0; i < cells.length; ++i) {
                        row.addCell("" + i).setContentAsString(cells[i]);
                    }
                } else {
                    row = result.addRow();
                    block17: for (i = 0; i < cells.length; ++i) {
                        Cell cell = row.addCell("" + i);
                        if (this.m_MissingValue.isMatch(cells[i]) || cells[i].isEmpty() && this.m_MissingValue.isEmpty()) {
                            cell.setMissing();
                            continue;
                        }
                        if (types[i] == null) {
                            cell.setContent(cells[i]);
                            continue;
                        }
                        switch (types[i]) {
                            case STRING: {
                                cell.setContentAsString(cells[i]);
                                continue block17;
                            }
                            case TIME: 
                            case TIMEMSEC: 
                            case DATE: 
                            case DATETIME: 
                            case DATETIMEMSEC: {
                                cell.setNative(cell.parseContent(cells[i], types[i]));
                                continue block17;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled cell type: " + types[i]);
                            }
                        }
                    }
                }
                first = false;
            }
        }
        catch (Exception e) {
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to read data!", (Throwable)e);
            return null;
        }
        return result;
    }

    public static void main(String[] args) {
        AutoWidthTabularSpreadSheetReader.runReader(Environment.class, AutoWidthTabularSpreadSheetReader.class, (String[])args);
    }
}

