/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.data.DateFormatString;
import adams.data.io.input.AutoWidthTabularSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractFormattedSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.NoHeaderSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Level;

public class AutoWidthTabularSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter
implements NoHeaderSpreadSheetWriter {
    private static final long serialVersionUID = -3173466155705306551L;
    protected int m_NumSpaces;
    protected String m_NewLine;
    protected DateFormatString m_DateFormat;
    protected DateFormatString m_DateTimeFormat;
    protected DateFormatString m_DateTimeMsecFormat;
    protected DateFormatString m_TimeFormat;
    protected boolean m_NoHeader;

    public String globalInfo() {
        return "Outputs the spreadsheet in a simple tabular format with column widths to fit the content in each row.";
    }

    public String getFormatDescription() {
        return new AutoWidthTabularSpreadSheetReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new AutoWidthTabularSpreadSheetReader().getFormatExtensions();
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new AutoWidthTabularSpreadSheetReader();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("num-spaces", "numSpaces", (Object)1, (Number)1, null);
        this.m_OptionManager.add("new-line", "newLine", (Object)Utils.backQuoteChars((String)System.getProperty("line.separator")));
        this.m_OptionManager.add("date-format", "dateFormat", (Object)new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("datetimemsec-format", "dateTimeMsecFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
        this.m_OptionManager.add("time-format", "timeFormat", (Object)new DateFormatString("HH:mm:ss"));
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
    }

    public void setNumSpaces(int value) {
        this.m_NumSpaces = value;
        this.reset();
    }

    public int getNumSpaces() {
        return this.m_NumSpaces;
    }

    public String numSpacesTipText() {
        return "The number of spaces to use between columns.";
    }

    public void setNewLine(String value) {
        this.m_NewLine = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getNewLine() {
        return Utils.backQuoteChars((String)this.m_NewLine);
    }

    public String newLineTipText() {
        return "The newline character(s) to use for the columns; use '\\r' for carriage return and '\\n' for line feed; Linux/Unix use '\\n', Windows uses '\\r\\n' and old Macs use '\\r'.";
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for dates.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/times.";
    }

    public void setDateTimeMsecFormat(DateFormatString value) {
        this.m_DateTimeMsecFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeMsecFormat() {
        return this.m_DateTimeMsecFormat;
    }

    public String dateTimeMsecFormatTipText() {
        return "The format for date/time msecs.";
    }

    public void setTimeFormat(DateFormatString value) {
        this.m_TimeFormat = value;
        this.reset();
    }

    public DateFormatString getTimeFormat() {
        return this.m_TimeFormat;
    }

    public String timeFormatTipText() {
        return "The format for times.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, no header is output.";
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    protected int[] determineColWidths(SpreadSheet content) {
        int i;
        int[] result = new int[content.getColumnCount()];
        int missingLen = this.m_MissingValue.length();
        DateFormat dformat = this.m_DateFormat.toDateFormat();
        DateFormat dtformat = this.m_DateTimeFormat.toDateFormat();
        DateFormat dtmformat = this.m_DateTimeMsecFormat.toDateFormat();
        DateFormat tformat = this.m_TimeFormat.toDateFormat();
        if (!this.m_NoHeader) {
            HeaderRow row = content.getHeaderRow();
            for (i = 0; i < result.length; ++i) {
                result[i] = !row.hasCell(i) || row.getCell(i).isMissing() ? Math.max(result[i], missingLen) : Math.max(result[i], row.getCell(i).getContent().length());
            }
        }
        for (Row drow : content.rows()) {
            if (this.m_Stopped) {
                return result;
            }
            for (i = 0; i < content.getColumnCount(); ++i) {
                String s;
                if (!drow.hasCell(i) || drow.getCell(i).isMissing()) {
                    result[i] = Math.max(result[i], missingLen);
                    continue;
                }
                Cell cell = drow.getCell(i);
                switch (cell.getContentType()) {
                    case LONG: {
                        s = drow.getCell(i).toLong().toString();
                        break;
                    }
                    case DOUBLE: {
                        s = this.format(drow.getCell(i).toDouble());
                        break;
                    }
                    case DATE: {
                        s = dformat.format(drow.getCell(i).toDate());
                        break;
                    }
                    case DATETIME: {
                        s = dtformat.format((Date)drow.getCell(i).toDateTime());
                        break;
                    }
                    case DATETIMEMSEC: {
                        s = dtmformat.format((Date)drow.getCell(i).toDateTimeMsec());
                        break;
                    }
                    case TIME: {
                        s = tformat.format((Date)drow.getCell(i).toTime());
                        break;
                    }
                    case BOOLEAN: {
                        s = drow.getCell(i).toBoolean().toString();
                        break;
                    }
                    default: {
                        s = drow.getCell(i).getContent();
                    }
                }
                result[i] = Math.max(result[i], s.length());
            }
        }
        return result;
    }

    protected String pad(String s, int width, boolean leftPad) {
        StringBuilder result = new StringBuilder(s);
        while (result.length() < width) {
            if (leftPad) {
                result.insert(0, " ");
                continue;
            }
            result.append(" ");
        }
        return result.toString();
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        int i;
        boolean result = true;
        int[] widths = this.determineColWidths(content);
        Object sep = "";
        for (i = 0; i < this.m_NumSpaces; ++i) {
            sep = (String)sep + " ";
        }
        try {
            DateFormat dformat = this.m_DateFormat.toDateFormat();
            DateFormat dtformat = this.m_DateTimeFormat.toDateFormat();
            DateFormat dtmformat = this.m_DateTimeMsecFormat.toDateFormat();
            DateFormat tformat = this.m_TimeFormat.toDateFormat();
            String[] missing = new String[content.getColumnCount()];
            for (i = 0; i < content.getColumnCount(); ++i) {
                missing[i] = this.pad(this.m_MissingValue, widths[i], false);
            }
            if (!this.m_NoHeader) {
                HeaderRow row = content.getHeaderRow();
                for (i = 0; i < content.getColumnCount(); ++i) {
                    if (i > 0) {
                        writer.write((String)sep);
                    }
                    if (!row.hasCell(i) || row.getCell(i).isMissing()) {
                        writer.write(missing[i]);
                        continue;
                    }
                    writer.write(this.pad(row.getCell(i).getContent(), widths[i], false));
                }
                writer.write(this.m_NewLine);
            }
            for (Row drow : content.rows()) {
                if (this.m_Stopped) {
                    return false;
                }
                block15: for (i = 0; i < content.getColumnCount(); ++i) {
                    if (i > 0) {
                        writer.write((String)sep);
                    }
                    if (!drow.hasCell(i) || drow.getCell(i).isMissing()) {
                        writer.write(missing[i]);
                        continue;
                    }
                    Cell cell = drow.getCell(i);
                    switch (cell.getContentType()) {
                        case LONG: {
                            writer.write(this.pad(drow.getCell(i).toLong().toString(), widths[i], true));
                            continue block15;
                        }
                        case DOUBLE: {
                            writer.write(this.pad(this.format(drow.getCell(i).toDouble()), widths[i], true));
                            continue block15;
                        }
                        case DATE: {
                            writer.write(this.pad(dformat.format(drow.getCell(i).toDate()), widths[i], false));
                            continue block15;
                        }
                        case DATETIME: {
                            writer.write(this.pad(dtformat.format((Date)drow.getCell(i).toDateTime()), widths[i], false));
                            continue block15;
                        }
                        case DATETIMEMSEC: {
                            writer.write(this.pad(dtmformat.format((Date)drow.getCell(i).toDateTimeMsec()), widths[i], false));
                            continue block15;
                        }
                        case TIME: {
                            writer.write(this.pad(tformat.format((Date)drow.getCell(i).toTime()), widths[i], false));
                            continue block15;
                        }
                        case BOOLEAN: {
                            writer.write(this.pad(drow.getCell(i).toBoolean().toString(), widths[i], false));
                            continue block15;
                        }
                        default: {
                            writer.write(this.pad(drow.getCell(i).getContent(), widths[i], false));
                        }
                    }
                }
                writer.write(this.m_NewLine);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }
}

