/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Properties;
import adams.data.io.input.PropertiesSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class PropertiesSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -6004699877865566744L;
    protected SpreadSheetColumnIndex m_Key;
    protected SpreadSheetColumnIndex m_Value;

    public String globalInfo() {
        return "Outputs two columns (key and value) from a spreadsheet as Java properties file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value", "value", (Object)new SpreadSheetColumnIndex("2"));
    }

    public void setKey(SpreadSheetColumnIndex value) {
        this.m_Key = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The column that acts as the key for the properties.";
    }

    public void setValue(SpreadSheetColumnIndex value) {
        this.m_Value = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The column that acts as the value for the properties.";
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new PropertiesSpreadSheetReader();
    }

    public String getFormatDescription() {
        return new PropertiesSpreadSheetReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new PropertiesSpreadSheetReader().getFormatExtensions();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.FILE;
    }

    protected boolean doWrite(SpreadSheet content, String filename) {
        this.m_Key.setData(content);
        int keyCol = this.m_Key.getIntIndex();
        if (keyCol == -1) {
            this.getLogger().severe("Key column not found: " + this.m_Key);
            return false;
        }
        this.m_Value.setData(content);
        int valueCol = this.m_Value.getIntIndex();
        if (valueCol == -1) {
            this.getLogger().severe("Value column not found: " + this.m_Value);
            return false;
        }
        Properties props = new Properties();
        for (Row row : content.rows()) {
            if (this.m_Stopped) {
                return false;
            }
            if (!row.hasCell(keyCol) || row.getCell(keyCol).isMissing()) continue;
            String key = row.getCell(keyCol).getContent();
            String value = "";
            if (row.hasCell(valueCol)) {
                value = row.getCell(valueCol).getContent();
            }
            props.setProperty(key, value);
        }
        return props.save(filename);
    }
}

