/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.RangeIterator;
import adams.data.spreadsheet.columnfinder.ByIndex;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import java.util.ArrayList;
import java.util.Iterator;

public class ColumnFinderRange
extends AbstractCellFinder {
    private static final long serialVersionUID = 3956527986917157099L;
    protected Range m_Rows;
    protected ColumnFinder m_ColumnFinder;

    public String globalInfo() {
        return "Uses a column finder to locate the interesting columns.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("column-finder", "columnFinder", (Object)new ByIndex());
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows to locate.";
    }

    public void setColumnFinder(ColumnFinder value) {
        this.m_ColumnFinder = value;
        this.reset();
    }

    public ColumnFinder getColumnFinder() {
        return this.m_ColumnFinder;
    }

    public String columnFinderTipText() {
        return "The column finder to use for locating the columns.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)"rows: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnFinder", (Object)this.m_ColumnFinder, (String)", col finder: ");
        return result;
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        this.m_Rows.setMax(sheet.getRowCount());
        int[] rows = this.m_Rows.getIntIndices();
        int[] cols = this.m_ColumnFinder.findColumns(sheet);
        if (rows.length > 0 && cols.length > 0) {
            return new RangeIterator(rows, cols);
        }
        return new ArrayList().iterator();
    }
}

