/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.PositionType;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.AbstractMetaIterator;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.ColumnFinderRange;
import java.util.Iterator;

public class CorrespondingColumn
extends AbstractCellFinder {
    private static final long serialVersionUID = -3837662374567098995L;
    protected CellFinder m_Finder;
    protected PositionType m_CorrespondingPosition;
    protected int m_CorrespondingColumn;

    public String globalInfo() {
        return "Rather than return a cell that was located using the given cell finder, you can return a corresponding cell (within the same row).\nThis allows you to locate cells with certain value but then update a different column in the same row. You can specify whether the position of the corresponding column is relative (+3 or -4) or absolute (5th).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new ColumnFinderRange());
        this.m_OptionManager.add("corresponding-position", "correspondingPosition", (Object)PositionType.RELATIVE);
        this.m_OptionManager.add("corresponding-column", "correspondingColumn", (Object)0);
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The base cell finder to locate the cells.";
    }

    public void setCorrespondingPosition(PositionType value) {
        this.m_CorrespondingPosition = value;
        this.reset();
    }

    public PositionType getCorrespondingPosition() {
        return this.m_CorrespondingPosition;
    }

    public String correspondingPositionTipText() {
        return "How to interpret the column position.";
    }

    public void setCorrespondingColumn(int value) {
        this.m_CorrespondingColumn = value;
        this.reset();
    }

    public int getCorrespondingColumn() {
        return this.m_CorrespondingColumn;
    }

    public String correspondingColumnTipText() {
        return "The location of the column: 1-based if absolute mode; 0 in relative mode is the column itself.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"correspondingPosition", (Object)this.m_CorrespondingPosition, (String)", type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"correspondingColumn", (Object)this.m_CorrespondingColumn, (String)", col: ");
        return result;
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        return new CorrespondingColumnIterator(this, this.m_Finder.findCells(sheet));
    }

    public static class CorrespondingColumnIterator
    extends AbstractMetaIterator {
        protected CorrespondingColumn m_Owner;

        public CorrespondingColumnIterator(CorrespondingColumn owner, Iterator<CellLocation> base) {
            super(base);
            this.m_Owner = owner;
        }

        @Override
        protected CellLocation process(CellLocation location) {
            switch (this.m_Owner.getCorrespondingPosition()) {
                case ABSOLUTE: {
                    return new CellLocation(location.getRow(), this.m_Owner.getCorrespondingColumn() - 1);
                }
                case RELATIVE: {
                    return new CellLocation(location.getRow(), location.getColumn() + this.m_Owner.getCorrespondingColumn());
                }
            }
            throw new IllegalStateException("Unhandled position: " + this.m_Owner.getCorrespondingPosition());
        }
    }
}

