/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.cellfinder.AbstractRowCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.ArrayList;
import java.util.Iterator;

public class SingleCell
extends AbstractRowCellFinder {
    private static final long serialVersionUID = 7552127288975155281L;
    protected Index m_Row;
    protected SpreadSheetColumnIndex m_Column;

    public String globalInfo() {
        return "Simple locator that just locates a single cell.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row to locate.";
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to locate.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)", col: ");
        return result;
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        ArrayList<CellLocation> result = new ArrayList<CellLocation>();
        this.m_Row.setMax(sheet.getRowCount());
        this.m_Column.setSpreadSheet(sheet);
        int row = this.m_Row.getIntIndex();
        int col = this.m_Column.getIntIndex();
        if (row != -1 && col != -1) {
            result.add(new CellLocation(row, col));
        }
        return result.iterator();
    }

    @Override
    protected Iterator<CellLocation> doFindCells(Row row) {
        ArrayList<CellLocation> result = new ArrayList<CellLocation>();
        this.m_Column.setSpreadSheet(row.getOwner());
        int col = this.m_Column.getIntIndex();
        if (col != -1) {
            result.add(new CellLocation(0, col));
        }
        return result.iterator();
    }
}

