/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractFilteredColumnFinder;
import adams.data.spreadsheet.columnfinder.TrainableColumnFinder;
import adams.data.spreadsheet.rowfinder.NullFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.data.spreadsheet.rowfinder.TrainableRowFinder;

public class RowFilteredColumnFinder
extends AbstractFilteredColumnFinder {
    private static final long serialVersionUID = -2963065019052042099L;
    protected RowFinder m_RowFinder;
    protected boolean m_ColumnFinderTrained;

    public String globalInfo() {
        return "Creates a subset of rows using the provided RowFinder first before finding the columns using the subset.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new NullFinder());
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder to use for generating the subset for the column finder.";
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"rowFinder", (Object)this.m_RowFinder, (String)", row finder: ");
        return result;
    }

    @Override
    protected boolean doTrainColumnFinder(SpreadSheet data) {
        boolean result = true;
        if (this.m_RowFinder instanceof TrainableRowFinder) {
            result = ((TrainableRowFinder)this.m_RowFinder).trainRowFinder(data);
        }
        this.m_ColumnFinderTrained = false;
        return result;
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        int[] rows = this.m_RowFinder.findRows(data);
        SpreadSheet subset = data.getHeader();
        for (int index : rows) {
            DataRow rowIn = data.getRow(index);
            DataRow rowOut = subset.addRow();
            for (int i = 0; i < data.getColumnCount(); ++i) {
                if (!rowIn.hasCell(i)) continue;
                rowOut.addCell(i).assign(rowIn.getCell(i));
            }
        }
        if (!this.m_ColumnFinderTrained) {
            this.m_ColumnFinderTrained = true;
            if (this.m_ColumnFinder instanceof TrainableColumnFinder) {
                this.m_ColumnFinderTrained = ((TrainableColumnFinder)this.m_ColumnFinder).trainColumnFinder(data);
            }
            if (!this.m_ColumnFinderTrained) {
                throw new IllegalStateException("Failed to train column finder on subset of rows!");
            }
        }
        int[] result = this.m_ColumnFinder.findColumns(subset);
        return result;
    }
}

