/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.filter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.filter.AbstractTrainableSpreadSheetFilter;
import java.util.Arrays;

public class Normalize
extends AbstractTrainableSpreadSheetFilter {
    private static final long serialVersionUID = 5377534668839214763L;
    protected SpreadSheetColumnRange m_Range;
    protected double m_Lower;
    protected double m_Upper;
    protected int[] m_Indices;
    protected boolean[] m_Numeric;
    protected double[] m_Min;
    protected double[] m_Max;

    public String globalInfo() {
        return "Normalizes numeric columns to the specified lower and upper bound.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("lower", "lower", (Object)0.0);
        this.m_OptionManager.add("upper", "upper", (Object)1.0);
    }

    public void setRange(SpreadSheetColumnRange value) {
        this.m_Range = value;
        this.reset();
    }

    public SpreadSheetColumnRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The column range to normalize.";
    }

    public void setLower(double value) {
        this.m_Lower = value;
        this.reset();
    }

    public double getLower() {
        return this.m_Lower;
    }

    public String lowerTipText() {
        return "The lower bound to use.";
    }

    public void setUpper(double value) {
        this.m_Upper = value;
        this.reset();
    }

    public double getUpper() {
        return this.m_Upper;
    }

    public String upperTipText() {
        return "The upper bound to use.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"lower", (Object)this.m_Lower, (String)"lower: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"upper", (Object)this.m_Upper, (String)", upper: ");
        return result;
    }

    @Override
    protected String checkTrain(SpreadSheet data) {
        Object result = super.checkTrain(data);
        if (result == null && this.m_Upper <= this.m_Lower) {
            result = "Upper bound must be larger than lower one: lower=" + this.m_Lower + ", upper=" + this.m_Upper;
        }
        return result;
    }

    @Override
    protected SpreadSheet doTrain(SpreadSheet data) throws Exception {
        this.m_Range.setData(data);
        this.m_Indices = this.m_Range.getIntIndices();
        this.m_Numeric = new boolean[data.getColumnCount()];
        Arrays.fill(this.m_Numeric, false);
        for (int index : this.m_Indices) {
            if (!data.isNumeric(index)) continue;
            this.m_Numeric[index] = true;
        }
        this.m_Min = new double[data.getColumnCount()];
        this.m_Max = new double[data.getColumnCount()];
        Arrays.fill(this.m_Min, Double.POSITIVE_INFINITY);
        Arrays.fill(this.m_Max, Double.NEGATIVE_INFINITY);
        for (Row row : data.rows()) {
            for (int index : this.m_Indices) {
                Cell cell;
                if (!this.m_Numeric[index] || !row.hasCell(index) || (cell = row.getCell(index)).isMissing()) continue;
                double value = cell.toDouble();
                this.m_Min[index] = Math.min(this.m_Min[index], value);
                this.m_Max[index] = Math.max(this.m_Max[index], value);
            }
        }
        for (int index : this.m_Indices) {
            if (!this.m_Numeric[index]) continue;
            if (Double.isInfinite(this.m_Min[index]) || Double.isInfinite(this.m_Max[index])) {
                this.m_Numeric[index] = false;
                continue;
            }
            if (this.m_Min[index] != this.m_Max[index]) continue;
            this.m_Numeric[index] = false;
        }
        return this.doFilter(data);
    }

    @Override
    protected SpreadSheet doFilter(SpreadSheet data) throws Exception {
        SpreadSheet result = data.getClone();
        for (Row row : result.rows()) {
            for (int index : this.m_Indices) {
                Cell cell;
                if (!this.m_Numeric[index] || !row.hasCell(index) || (cell = row.getCell(index)).isMissing()) continue;
                cell.setContent(Double.valueOf((cell.toDouble() - this.m_Min[index]) / (this.m_Max[index] - this.m_Min[index]) * (this.m_Upper - this.m_Lower) + this.m_Lower));
            }
        }
        return result;
    }
}

