/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class ByContentType
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected Cell.ContentType m_ContentType;

    public String globalInfo() {
        return "Returns the indices of rows of columns that match the specified content type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("content-type", "contentType", (Object)Cell.ContentType.STRING);
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setContentType(Cell.ContentType value) {
        this.m_ContentType = value;
        this.reset();
    }

    public Cell.ContentType getContentType() {
        return this.m_ContentType;
    }

    public String contentTypeTipText() {
        return "The content type to look for.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"contentType", (Object)this.m_ContentType, (String)", type: ");
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).getContentType() != this.m_ContentType) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

