/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseInterval;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class ByNumericRange
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected BaseInterval[] m_Ranges;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values fall inside the minimum and maximum.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("range", "ranges", (Object)new BaseInterval[]{new BaseInterval("(-Infinity;+Infinity)")});
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setRanges(BaseInterval[] value) {
        this.m_Ranges = value;
        this.reset();
    }

    public BaseInterval[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The intervals to use for matching numeric values.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"ranges", (Object)this.m_Ranges, (String)", ranges: ");
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.isNumeric(index, true)) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is not numeric!");
        }
        block0: for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing() || !cell.isNumeric()) continue;
            double value = cell.toDouble();
            for (int n = 0; n < this.m_Ranges.length; ++n) {
                if (!this.m_Ranges[n].isInside(value)) continue;
                result.add(i);
                continue block0;
            }
        }
        return result.toArray();
    }
}

