/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class ByStringComparison
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected String m_Minimum;
    protected boolean m_MinimumIncluded;
    protected String m_Maximum;
    protected boolean m_MaximumIncluded;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values fall inside the minimum and maximum.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("minimum", "minimum", (Object)"");
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)"");
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setMinimum(String value) {
        this.m_Minimum = value;
        this.reset();
    }

    public String getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum string value that the values must satisfy; use empty string to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(String value) {
        this.m_Maximum = value;
        this.reset();
    }

    public String getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum string value that the values must satisfy; use empty string to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)(this.m_Minimum.isEmpty() ? "-none-" : this.m_Minimum), (String)", min: ");
        result = (String)result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"minimumIncluded", (Object)(this.m_MinimumIncluded ? "incl" : "excl")) + "]";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)(this.m_Maximum.isEmpty() ? "-none-" : this.m_Maximum), (String)", max: ");
        result = (String)result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"maximumIncluded", (Object)(this.m_MaximumIncluded ? "incl" : "excl")) + "]";
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing()) continue;
            String value = cell.getContent();
            boolean add = true;
            if (!this.m_Minimum.isEmpty()) {
                if (this.m_MinimumIncluded) {
                    if (value.compareTo(this.m_Minimum) < 0) {
                        add = false;
                    }
                } else if (value.compareTo(this.m_Minimum) <= 0) {
                    add = false;
                }
            }
            if (!this.m_Maximum.isEmpty()) {
                if (this.m_MaximumIncluded) {
                    if (value.compareTo(this.m_Maximum) > 0) {
                        add = false;
                    }
                } else if (value.compareTo(this.m_Maximum) >= 0) {
                    add = false;
                }
            }
            if (!add) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

