/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class ByValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values match the provided regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the column's values against.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", regexp: ");
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (data.isNumeric(index, true)) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is numeric!");
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing() || cell.isNumeric() || !this.m_RegExp.isMatch(cell.getContent())) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

