/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.Index;
import adams.core.Range;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;

public class ArrayStatistic
extends AbstractRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected AbstractArrayStatistic m_Statistic;
    protected Range m_AdditionalRows;
    protected SpreadSheetColumnIndex m_Column;
    protected Index m_Row;

    public String globalInfo() {
        return "Applies the specified array statistic algorithm and returns the specified cell's value as score.\nNB: Only collects numeric values from the rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistic", (Object)new ArrayMean());
        this.m_OptionManager.add("additional-rows", "additionalRows", (Object)new Range());
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
    }

    public void setStatistic(AbstractArrayStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractArrayStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The array statistic to use.";
    }

    public void setAdditionalRows(Range value) {
        this.m_AdditionalRows = value;
        this.reset();
    }

    public Range getAdditionalRows() {
        return this.m_AdditionalRows;
    }

    public String additionalRowsTipText() {
        return "The additional rows to feed into the array statistic.";
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the cell from the row statistic's output to use as score.";
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the cell from the row statistic's output to use as score.";
    }

    @Override
    public int getNumScores() {
        return 1;
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Cell cell;
        Double[] result = null;
        TIntArrayList rows = new TIntArrayList();
        if (!this.m_AdditionalRows.isEmpty()) {
            this.m_AdditionalRows.setMax(sheet.getRowCount());
            rows.addAll(this.m_AdditionalRows.getIntIndices());
            if (this.m_Statistic.getMin() == 1) {
                rows.remove(rowIndex);
            }
        }
        rows.insert(0, rowIndex);
        this.m_Statistic.clear();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < rows.size(); ++i) {
            values.clear();
            for (int n = 0; n < sheet.getColumnCount(); ++n) {
                cell = sheet.getCell(rows.get(i), n);
                if (cell == null || !cell.isNumeric()) continue;
                values.add(cell.toDouble());
            }
            this.m_Statistic.add((Serializable[])values.toArray(new Double[values.size()]));
        }
        SpreadSheet stats = this.m_Statistic.calculate().toSpreadSheet();
        this.m_Column.setData(stats);
        int col = this.m_Column.getIntIndex();
        this.m_Row.setMax(stats.getRowCount());
        int row = this.m_Row.getIntIndex();
        if (col == -1) {
            this.m_LastError = "Failed to locate column: " + this.m_Column;
        } else if (row == -1) {
            this.m_LastError = "Failed to locate row: " + this.m_Row;
        } else {
            cell = stats.getCell(row, col);
            if (cell == null) {
                this.m_LastError = "Statistics output didn't have cell at " + this.m_Row + "/" + this.m_Column + "!";
            } else if (!cell.isNumeric()) {
                this.m_LastError = "Cell at " + this.m_Row + "/" + this.m_Column + " is not numeric!";
            } else {
                result = new Double[]{cell.toDouble()};
            }
        }
        return result;
    }
}

