/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractMetaRowScore;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.lang.invoke.CallSite;
import java.util.HashMap;

public class MathExpression
extends AbstractMetaRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected MathematicalExpressionText m_Expression;

    public String globalInfo() {
        return "Uses a mathematical expression to post-process or combine the score(s) returned from the base row score algorithm.\nThe individual scores of the base algorithm can be accessed using placeholders of the format: [n] with 'n' being the 1-based index in the score array.\n'null' scores get interpreted as 'NaN'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", (Object)new MathematicalExpressionText("[1]"));
    }

    @Override
    public String rowScoreTipText() {
        return "The row score algorithm to obtain the scores from.";
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to use for post-processing/combining the score(s) of the base algorithm.";
    }

    @Override
    public int getNumScores() {
        return this.m_RowScore.getNumScores();
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        Double[] scores = this.m_RowScore.calculateScore(sheet, rowIndex);
        if (scores == null) {
            return result;
        }
        HashMap<CallSite, Double> symbols = new HashMap<CallSite, Double>();
        for (int i = 0; i < scores.length; ++i) {
            if (scores[i] == null) {
                symbols.put((CallSite)((Object)("" + (i + 1))), Double.NaN);
                continue;
            }
            symbols.put((CallSite)((Object)("" + (i + 1))), scores[i]);
        }
        try {
            result = new Double[]{MathematicalExpression.evaluate((String)this.m_Expression.getValue(), symbols)};
        }
        catch (Exception e) {
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to process expression '" + this.m_Expression + "' using symbols '" + symbols + "':"), (Throwable)e);
        }
        return result;
    }
}

