/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.Index;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import adams.data.spreadsheet.rowstatistic.Mean;

public class RowStatistic
extends AbstractRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected AbstractRowStatistic m_Statistic;
    protected SpreadSheetColumnIndex m_Column;
    protected Index m_Row;

    public String globalInfo() {
        return "Applies the specified row statistic algorithm and returns the specified cell's value as score.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistic", (Object)new Mean());
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("row", "row", (Object)new Index("1"));
    }

    public void setStatistic(AbstractRowStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractRowStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The row statistic to use.";
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the cell from the row statistic's output to use as score.";
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the cell from the row statistic's output to use as score.";
    }

    @Override
    public int getNumScores() {
        return 1;
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        SpreadSheet stats = this.m_Statistic.generate(sheet, rowIndex);
        if (stats == null) {
            this.m_LastError = "No statistics generated";
            if (this.m_Statistic.hasLastError()) {
                this.m_LastError = this.m_LastError + ": " + this.m_Statistic.getLastError();
            }
        } else {
            this.m_Column.setData(stats);
            int col = this.m_Column.getIntIndex();
            this.m_Row.setMax(stats.getRowCount());
            int row = this.m_Row.getIntIndex();
            if (col == -1) {
                this.m_LastError = "Failed to locate column: " + this.m_Column;
            } else if (row == -1) {
                this.m_LastError = "Failed to locate row: " + this.m_Row;
            } else {
                Cell cell = stats.getCell(row, col);
                if (cell == null) {
                    this.m_LastError = "Statistics output didn't have cell at " + this.m_Row + "/" + this.m_Column + "!";
                } else if (!cell.isNumeric()) {
                    this.m_LastError = "Cell at " + this.m_Row + "/" + this.m_Column + " is not numeric!";
                } else {
                    result = new Double[]{cell.toDouble()};
                }
            }
        }
        return result;
    }
}

