/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;

public class Missing
extends AbstractRowStatistic {
    private static final long serialVersionUID = 2725451104774755739L;
    protected int m_Count;

    public String globalInfo() {
        return "Counts the missing cells.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int rowIndex) {
        this.m_Count = 0;
    }

    @Override
    protected void doVisit(Row row, int colIndex) {
        if (!row.hasCell(colIndex) || row.getCell(colIndex).isMissing()) {
            ++this.m_Count;
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = this.createOutputHeader();
        DataRow row = result.addRow();
        row.addCell(0).setContent("Missing");
        row.addCell(1).setContent(Integer.valueOf(this.m_Count));
        return result;
    }
}

