/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.MessageCollection;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.db.MetaDataType;
import adams.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;

public class MetaDataUtils {
    protected static Logger LOGGER = LoggingHelper.getLogger(MetaDataUtils.class);
    public static String[] JDBC_VALUES = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "autoCommitFailureClosesAllResultSets", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "generatedKeyAlwaysReturned", "getCatalogSeparator", "getCatalogTerm", "getDatabaseMajorVersion", "getDatabaseMinorVersion", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getJDBCMajorVersion", "getJDBCMinorVersion", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxLogicalLobSize", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getResultSetHoldability", "getRowIdLifetime", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getSQLStateType", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "locatorsUpdateCopy", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGetGeneratedKeys", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleOpenResults", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNamedParameters", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsRefCursors", "supportsSavepoints", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStatementPooling", "supportsStoredFunctionsUsingCallSyntax", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};

    protected static void addRow(SpreadSheet sheet, String key, Object value) {
        DataRow row = sheet.addRow();
        row.addCell("K").setContentAsString(key);
        row.addCell("V").setNative(value);
    }

    protected static void addRow(DatabaseMetaData metadata, SpreadSheet sheet, String key) {
        try {
            Method method = metadata.getClass().getMethod((String)key, new Class[0]);
            if (((String)key).startsWith("get")) {
                key = ((String)key).substring(3);
            }
            key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
            MetaDataUtils.addRow(sheet, (String)key, method.invoke((Object)metadata, new Object[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve value for: " + (String)key, (Throwable)e);
        }
    }

    public static MetaDataType[] typesRequireTable() {
        return new MetaDataType[]{MetaDataType.COLUMN_PRIVILEGES, MetaDataType.EXPORTED_KEYS, MetaDataType.IMPORTED_KEYS, MetaDataType.INDEX_INFO, MetaDataType.PRIMARY_KEYS, MetaDataType.VERSION_COLUMNS};
    }

    public static SpreadSheet getMetaData(AbstractDatabaseConnection conn, AbstractTypeMapper mapper, MetaDataType type, String table, MessageCollection errors) {
        DefaultSpreadSheet result = null;
        ResultSet rs = null;
        try {
            Connection dbconn = conn.getConnection(false);
            DatabaseMetaData metadata = dbconn.getMetaData();
            Reader reader = new Reader(mapper, DenseDataRow.class);
            switch (type) {
                case CONNECTION: {
                    result = new DefaultSpreadSheet();
                    HeaderRow row = result.getHeaderRow();
                    row.addCell("K").setContentAsString("Key");
                    row.addCell("V").setContentAsString("Value");
                    String db = conn.getURL().replaceAll(".*\\/", "");
                    if (db.contains("?")) {
                        db = db.substring(0, db.indexOf("?"));
                    }
                    MetaDataUtils.addRow((SpreadSheet)result, "URL", (Object)conn.getURL());
                    MetaDataUtils.addRow((SpreadSheet)result, "Database", (Object)db);
                    MetaDataUtils.addRow((SpreadSheet)result, "User", (Object)conn.getUser());
                    MetaDataUtils.addRow((SpreadSheet)result, "Password", (Object)conn.getPassword().getValue());
                    break;
                }
                case BASIC: {
                    result = new DefaultSpreadSheet();
                    HeaderRow row = result.getHeaderRow();
                    row.addCell("K").setContentAsString("Key");
                    row.addCell("V").setContentAsString("Value");
                    for (String value : JDBC_VALUES) {
                        MetaDataUtils.addRow(metadata, (SpreadSheet)result, value);
                    }
                    break;
                }
                case ATTRIBUTES: {
                    rs = metadata.getAttributes(dbconn.getCatalog(), null, "%", null);
                    result = reader.read(rs);
                    break;
                }
                case CATALOGS: {
                    rs = metadata.getCatalogs();
                    result = reader.read(rs);
                    break;
                }
                case CLIENT_INFO_PROPERTIES: {
                    rs = metadata.getClientInfoProperties();
                    result = reader.read(rs);
                    break;
                }
                case COLUMN_PRIVILEGES: {
                    rs = metadata.getColumnPrivileges(dbconn.getCatalog(), null, table, "%");
                    result = reader.read(rs);
                    break;
                }
                case COLUMNS: {
                    rs = metadata.getColumns(dbconn.getCatalog(), null, "%", "%");
                    result = reader.read(rs);
                    break;
                }
                case EXPORTED_KEYS: {
                    rs = metadata.getExportedKeys(dbconn.getCatalog(), null, table);
                    result = reader.read(rs);
                    break;
                }
                case FUNCTION_COLUMNS: {
                    rs = metadata.getFunctionColumns(dbconn.getCatalog(), null, "%", "%");
                    result = reader.read(rs);
                    break;
                }
                case FUNCTIONS: {
                    rs = metadata.getFunctions(dbconn.getCatalog(), null, "%");
                    result = reader.read(rs);
                    break;
                }
                case IMPORTED_KEYS: {
                    rs = metadata.getImportedKeys(dbconn.getCatalog(), null, table);
                    result = reader.read(rs);
                    break;
                }
                case INDEX_INFO: {
                    rs = metadata.getIndexInfo(dbconn.getCatalog(), null, table, false, false);
                    result = reader.read(rs);
                    break;
                }
                case PRIMARY_KEYS: {
                    rs = metadata.getPrimaryKeys(dbconn.getCatalog(), null, table);
                    result = reader.read(rs);
                    break;
                }
                case PROCEDURE_COLUMNS: {
                    rs = metadata.getProcedureColumns(dbconn.getCatalog(), null, "%", "%");
                    result = reader.read(rs);
                    break;
                }
                case PROCEDURES: {
                    rs = metadata.getProcedures(dbconn.getCatalog(), null, "%");
                    result = reader.read(rs);
                    break;
                }
                case PSEUDO_COLUMNS: {
                    rs = metadata.getPseudoColumns(dbconn.getCatalog(), null, "%", "%");
                    result = reader.read(rs);
                    break;
                }
                case SCHEMAS: {
                    rs = metadata.getSchemas();
                    result = reader.read(rs);
                    break;
                }
                case SUPER_TABLES: {
                    rs = metadata.getSuperTables(dbconn.getCatalog(), null, "%");
                    result = reader.read(rs);
                    break;
                }
                case SUPER_TYPES: {
                    rs = metadata.getSuperTypes(dbconn.getCatalog(), null, "%");
                    result = reader.read(rs);
                    break;
                }
                case TABLE_TYPES: {
                    rs = metadata.getTableTypes();
                    result = reader.read(rs);
                    break;
                }
                case TABLES: {
                    rs = metadata.getTables(dbconn.getCatalog(), null, "%", null);
                    result = reader.read(rs);
                    break;
                }
                case TYPE_INFO: {
                    rs = metadata.getTypeInfo();
                    result = reader.read(rs);
                    break;
                }
                case USER_DEFINED_TYPES: {
                    rs = metadata.getUDTs(dbconn.getCatalog(), null, "%", null);
                    result = reader.read(rs);
                    break;
                }
                case VERSION_COLUMNS: {
                    rs = metadata.getVersionColumns(dbconn.getCatalog(), null, table);
                    result = reader.read(rs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled meta-data type: " + type);
                }
            }
        }
        catch (Exception e) {
            errors.add("Failed to obtain database meta-data!", (Throwable)e);
        }
        SQLUtils.closeAll(rs);
        if (!errors.isEmpty()) {
            return null;
        }
        return result;
    }
}

