/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class HasRows
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 2973832676958171541L;
    protected int m_MinRows;
    protected int m_MaxRows;

    public String globalInfo() {
        return "Checks whether the spreadsheet passing through has the required number of rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-rows", "minRows", (Object)1, (Number)-1, null);
        this.m_OptionManager.add("max-rows", "maxRows", (Object)-1, (Number)-1, null);
    }

    public void setMinRows(int value) {
        if (this.getOptionManager().isValid("minRows", (Number)value)) {
            this.m_MinRows = value;
            this.reset();
        }
    }

    public int getMinRows() {
        return this.m_MinRows;
    }

    public String minRowsTipText() {
        return "The minimum number of rows that the spreadsheet needs to have, no lower bound if -1.";
    }

    public void setMaxRows(int value) {
        if (this.getOptionManager().isValid("maxRows", (Number)value)) {
            this.m_MaxRows = value;
            this.reset();
        }
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public String maxRowsTipText() {
        return "The maximum number of rows that the spreadsheet can have, no upper bound if -1.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"minRows", (Object)(this.m_MinRows == -1 ? "-any-" : "" + this.m_MinRows), (String)"min rows: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxRows", (Object)(this.m_MaxRows == -1 ? "-any-" : "" + this.m_MaxRows), (String)", max rows: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = token.getPayload() instanceof SpreadSheet;
        if (result) {
            SpreadSheet sheet = (SpreadSheet)token.getPayload();
            if (this.m_MinRows > -1) {
                boolean bl = result = sheet.getRowCount() >= this.m_MinRows;
            }
            if (this.m_MaxRows > -1) {
                result = sheet.getRowCount() <= this.m_MaxRows;
            }
        }
        return result;
    }
}

