/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.ColorProviderHandler;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.ChartUtils;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import adams.gui.visualization.jfreechart.shape.AbstractShapeGenerator;
import adams.gui.visualization.jfreechart.shape.Default;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;

public class JFreeChartPlot
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
ColorProviderHandler {
    private static final long serialVersionUID = -2648121220428217287L;
    protected AbstractDatasetGenerator m_Dataset;
    protected AbstractChartGenerator m_Chart;
    protected AbstractShapeGenerator m_Shape;
    protected Color m_PlotColor;
    protected ColorProvider m_ColorProvider;
    protected Color m_DiagonalColor;
    protected JFreeChart m_JFreeChart;
    protected ChartPanel m_PlotPanel;

    public String globalInfo() {
        return "Generates and displays a plot using JFreeChart.Dataset generation is skipped if the incoming data already represents a JFreeChart dataset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
        this.m_OptionManager.add("chart", "chart", (Object)new XYLineChart());
        this.m_OptionManager.add("shape", "shape", (Object)new Default());
        this.m_OptionManager.add("plot-color", "plotColor", (Object)Color.BLUE);
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("diagonal-color", "diagonalColor", (Object)Color.BLACK);
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public void setChart(AbstractChartGenerator value) {
        this.m_Chart = value;
        this.reset();
    }

    public AbstractChartGenerator getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The chart generator to use.";
    }

    public void setShape(AbstractShapeGenerator value) {
        this.m_Shape = value;
        this.reset();
    }

    public AbstractShapeGenerator getShape() {
        return this.m_Shape;
    }

    public String shapeTipText() {
        return "The shape generator to use for the data point markers.";
    }

    public void setPlotColor(Color value) {
        this.m_PlotColor = value;
        this.reset();
    }

    public Color getPlotColor() {
        return this.m_PlotColor;
    }

    public String plotColorTipText() {
        return "The color for the plot.";
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for coloring in the trimap image.";
    }

    public void setDiagonalColor(Color value) {
        this.m_DiagonalColor = value;
        this.reset();
    }

    public Color getDiagonalColor() {
        return this.m_DiagonalColor;
    }

    public String diagonalColorTipText() {
        return "The color for the diagonal (ie second data series if present).";
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)", dataset: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)((Object)this.m_Chart), (String)", chart: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"shape", (Object)((Object)this.m_Shape), (String)", shape: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Dataset.class};
    }

    protected void display(Token token) {
        Object dataset;
        if (token.hasPayload(SpreadSheet.class)) {
            SpreadSheet sheet = (SpreadSheet)token.getPayload();
            dataset = this.m_Dataset.generate(sheet);
        } else {
            dataset = (Dataset)token.getPayload(Dataset.class);
        }
        this.m_JFreeChart = this.m_Chart.generate(dataset);
        this.m_JFreeChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        if (this.m_JFreeChart.getPlot() instanceof XYPlot) {
            XYPlot plot = (XYPlot)this.m_JFreeChart.getPlot();
            Shape shape = this.m_Shape.generate();
            plot.setDomainGridlinesVisible(true);
            plot.setDomainGridlinePaint((Paint)Color.GRAY);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.GRAY);
            ChartUtils.applyColor(plot, this.m_PlotColor, this.m_DiagonalColor, this.m_ColorProvider);
            ChartUtils.applyShape(plot, shape);
        }
        this.m_PlotPanel = new ChartPanel(this.m_JFreeChart);
        this.m_Panel.removeAll();
        this.m_Panel.add((Component)this.m_PlotPanel, (Object)"Center");
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        this.m_Panel.removeAll();
        this.m_JFreeChart = null;
    }

    protected BasePanel newPanel() {
        return new BasePanel();
    }

    public JComponent supplyComponent() {
        return this.m_PlotPanel;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -3785685146120118884L;
            protected JFreeChart m_JFreeChart;
            protected ChartPanel m_PlotPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
            }

            public void display(Token token) {
                SpreadSheet sheet = (SpreadSheet)token.getPayload();
                Object dataset = JFreeChartPlot.this.m_Dataset.generate(sheet);
                this.m_JFreeChart = JFreeChartPlot.this.m_Chart.generate(dataset);
                if (this.m_JFreeChart.getPlot() instanceof XYPlot) {
                    XYPlot plot = (XYPlot)this.m_JFreeChart.getPlot();
                    Shape shape = JFreeChartPlot.this.m_Shape.generate();
                    plot.setDomainGridlinesVisible(true);
                    plot.setDomainGridlinePaint((Paint)Color.GRAY);
                    plot.setRangeGridlinesVisible(true);
                    plot.setRangeGridlinePaint((Paint)Color.GRAY);
                    plot.getRenderer().setSeriesPaint(0, (Paint)JFreeChartPlot.this.m_PlotColor);
                    ChartUtils.applyColor(plot, JFreeChartPlot.this.m_PlotColor, JFreeChartPlot.this.m_DiagonalColor, JFreeChartPlot.this.m_ColorProvider);
                    ChartUtils.applyShape(plot, shape);
                }
                this.m_PlotPanel = new ChartPanel(this.m_JFreeChart);
                this.removeAll();
                this.add((Component)this.m_PlotPanel, "Center");
            }

            public void clearPanel() {
                this.removeAll();
                this.m_JFreeChart = null;
            }

            public void cleanUp() {
                this.removeAll();
                this.m_JFreeChart = null;
            }

            public JComponent supplyComponent() {
                return this.m_PlotPanel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

