/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.BatchSizeSupporter;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Writer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionUser;
import adams.db.SQLF;
import adams.db.SQLIntf;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.DatabaseConnectionProvider;

public class SpreadSheetDbWriter
extends AbstractSink
implements BatchSizeSupporter,
DatabaseConnectionUser {
    private static final long serialVersionUID = 393925191813730213L;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected AbstractTypeMapper m_TypeMapper;
    protected String m_Table;
    protected Cell.ContentType[] m_Types;
    protected int m_MaxColumnLength;
    protected String[] m_ColumnNames;
    protected ColumnNameConversion m_ColumnNameConversion;
    protected String m_StringColumnSQL;
    protected int m_MaxStringLength;
    protected int m_BatchSize;
    protected Writer m_Writer;

    public String globalInfo() {
        return "Transfers a SpreadSheet object into a database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type-mapper", "typeMapper", (Object)new DefaultTypeMapper());
        this.m_OptionManager.add("table", "table", (Object)"blah");
        this.m_OptionManager.add("column-name-conversion", "columnNameConversion", (Object)ColumnNameConversion.UPPER_CASE);
        this.m_OptionManager.add("max-string-length", "maxStringLength", (Object)50, (Number)1, null);
        this.m_OptionManager.add("string-column-sql", "stringColumnSQL", (Object)"VARCHAR(@MAX)");
        this.m_OptionManager.add("batch-size", "batchSize", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_DatabaseConnection = null;
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"table", (Object)this.m_Table, (String)"table: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnNameConversion", (Object)((Object)this.m_ColumnNameConversion), (String)", conversion: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxStringLength", (Object)this.m_MaxStringLength, (String)", max string: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"stringColumnSQL", (Object)this.m_StringColumnSQL, (String)", string type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"batchSize", (Object)this.m_BatchSize, (String)", batch: ");
        return result;
    }

    public void setTypeMapper(AbstractTypeMapper value) {
        this.m_TypeMapper = value;
        this.reset();
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String typeMapperTipText() {
        return "The type mapper to use for mapping spreadsheet and SQL types.";
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to write the data to (gets automatically created).";
    }

    public void setColumnNameConversion(ColumnNameConversion value) {
        this.m_ColumnNameConversion = value;
        this.reset();
    }

    public ColumnNameConversion getColumnNameConversion() {
        return this.m_ColumnNameConversion;
    }

    public String columnNameConversionTipText() {
        return "How to convert the column headers into SQL table column names.";
    }

    public void setMaxStringLength(int value) {
        if (this.getOptionManager().isValid("maxStringLength", (Number)value)) {
            this.m_MaxStringLength = value;
            this.reset();
        }
    }

    public int getMaxStringLength() {
        return this.m_MaxStringLength;
    }

    public String maxStringLengthTipText() {
        return "The maximum length for strings to enforce; can be used as @MAX in the 'stringColumnsSQL' property.";
    }

    public void setStringColumnSQL(String value) {
        this.m_StringColumnSQL = value;
        this.reset();
    }

    public String getStringColumnSQL() {
        return this.m_StringColumnSQL;
    }

    public String stringColumnSQLTipText() {
        return "The SQL type to use for STRING columns in the CREATE statement; you can use the @MAX placeholder to tie the type to the 'naxStringLength' property; see also: http://en.wikipedia.org/wiki/SQL";
    }

    public void setBatchSize(int value) {
        if (this.getOptionManager().isValid("batchSize", (Number)value)) {
            this.m_BatchSize = value;
            this.reset();
        }
    }

    public int getBatchSize() {
        return this.m_BatchSize;
    }

    public String batchSizeTipText() {
        return "The size of the batch when inserting the data; can help improve speed of data import.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Row.class};
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this, DatabaseConnectionProvider.class, (AbstractDatabaseConnection)DatabaseConnection.getSingleton());
    }

    protected String doExecute() {
        SpreadSheet sheet;
        String result = null;
        if (this.m_DatabaseConnection == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        if (this.m_InputToken.getPayload() instanceof Row) {
            Row row = (Row)this.m_InputToken.getPayload();
            sheet = row.getOwner().getClone();
            sheet.clear();
            sheet.addRow().assign(row);
        } else {
            sheet = (SpreadSheet)this.m_InputToken.getPayload();
        }
        SQLF sql = SQLF.getSingleton((AbstractDatabaseConnection)this.m_DatabaseConnection);
        sql.setDebug(this.isLoggingEnabled());
        this.m_Writer = null;
        try {
            this.m_Writer = new Writer(sheet, this.m_TypeMapper, this.m_Table, sql.getMaxColumnNameLength(), this.m_ColumnNameConversion, this.m_StringColumnSQL, this.m_MaxStringLength, this.m_BatchSize);
            this.m_Writer.setLoggingLevel(this.getLoggingLevel());
        }
        catch (Exception e) {
            this.m_Writer = null;
            result = this.handleException("Failed to determine max column name length", e);
        }
        if (this.m_Writer != null) {
            if (!sql.tableExists(this.m_Table)) {
                result = this.m_Writer.createTable((SQLIntf)sql);
            }
            if (result == null) {
                result = this.m_Writer.writeData((SQLIntf)sql);
            }
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Writer != null) {
            this.m_Writer.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

