/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.db.AbstractDatabaseConnection;
import adams.db.MetaDataType;
import adams.db.MetaDataUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleDbSource;

public abstract class AbstractDatabaseMetaData
extends AbstractSimpleDbSource {
    private static final long serialVersionUID = -8462709950859959951L;
    protected AbstractTypeMapper m_TypeMapper;
    protected MetaDataType m_MetaDataType;
    protected String m_Table;

    public String globalInfo() {
        return "Outputs the meta-data of the current database connection.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type-mapper", "typeMapper", (Object)new DefaultTypeMapper());
        this.m_OptionManager.add("meta-data-type", "metaDataType", (Object)MetaDataType.BASIC);
        this.m_OptionManager.add("table", "table", (Object)"");
    }

    public void setTypeMapper(AbstractTypeMapper value) {
        this.m_TypeMapper = value;
        this.reset();
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String typeMapperTipText() {
        return "The type mapper to use for mapping spreadsheet and SQL types.";
    }

    public void setMetaDataType(MetaDataType value) {
        this.m_MetaDataType = value;
        this.reset();
    }

    public MetaDataType getMetaDataType() {
        return this.m_MetaDataType;
    }

    public String metaDataTypeTipText() {
        return "The type of meta-data to retrieve.";
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to retrieve the information for (" + Utils.flatten((Object[])MetaDataUtils.typesRequireTable(), (String)", ") + ").";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataType", (Object)((Object)this.m_MetaDataType), (String)"type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"table", (Object)(this.m_Table.isEmpty() ? "-none-" : this.m_Table), (String)", table: ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    protected String queryDatabase() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        SpreadSheet sheet = MetaDataUtils.getMetaData(this.m_DatabaseConnection, this.m_TypeMapper, this.m_MetaDataType, this.m_Table, errors);
        if (!errors.isEmpty()) {
            result = errors.toString();
        } else if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

