/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Actor;
import adams.flow.core.MissingLookUpKey;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUp
extends AbstractTransformer
implements StorageUser {
    private static final long serialVersionUID = 444466366407383727L;
    protected StorageName m_StorageName;
    protected MissingLookUpKey m_MissingKey;
    protected String m_MissingValue;
    protected boolean m_UseNative;
    protected boolean m_SuppressMissingKeyWarnings;

    public String globalInfo() {
        return "Forwards the value associated with the key that the actor gets as input, using the specified lookup table from internal storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("missing-key", "missingKey", (Object)MissingLookUpKey.NO_OUTPUT);
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"???");
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
        this.m_OptionManager.add("suppress-missing-key-warnings", "suppressMissingKeyWarnings", (Object)false);
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingKey", (Object)((Object)this.m_MissingKey), (String)", missing: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingValue", (Object)this.m_MissingValue, (String)", value: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = (String)result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"suppressMissingKeyWarnings", (boolean)this.m_SuppressMissingKeyWarnings, (String)", no missing key warnings")) != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public void setMissingKey(MissingLookUpKey value) {
        this.m_MissingKey = value;
        this.reset();
    }

    public MissingLookUpKey getMissingKey() {
        return this.m_MissingKey;
    }

    public String missingKeyTipText() {
        return "The behavior in case a lookup key is missing (ie not found in the lookup table).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to forward if the missing key behavior is " + MissingLookUpKey.OUTPUT_MISSING_VALUE + ".";
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are output rather than strings.";
    }

    public void setSuppressMissingKeyWarnings(boolean value) {
        this.m_SuppressMissingKeyWarnings = value;
        this.reset();
    }

    public boolean getSuppressMissingKeyWarnings() {
        return this.m_SuppressMissingKeyWarnings;
    }

    public String suppressMissingKeyWarningsTipText() {
        return "If enabled, warnings about missing keys are suppressed.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        if (this.m_UseNative) {
            return new Class[]{Object.class};
        }
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            String key;
            HashMap<String, Object> lookup = LookUpHelper.getTable((Actor)this, this.m_StorageName);
            if (lookup.containsKey(key = (String)this.m_InputToken.getPayload())) {
                Object value = lookup.get(key);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Lookup: '" + key + "' -> '" + value + "'");
                }
                this.m_OutputToken = new Token(value);
            } else {
                switch (this.m_MissingKey) {
                    case NO_OUTPUT: {
                        if (this.m_SuppressMissingKeyWarnings) break;
                        this.getLogger().severe("Key '" + key + "' not available from lookup table '" + this.m_StorageName + "'!");
                        break;
                    }
                    case CAUSE_ERROR: {
                        if (!this.m_SuppressMissingKeyWarnings) {
                            this.getLogger().severe("Key '" + key + "' not available from lookup table '" + this.m_StorageName + "'!");
                        }
                        result = "Key '" + key + "' not available from lookup table '" + this.m_StorageName + "'!";
                        break;
                    }
                    case OUTPUT_KEY: {
                        this.m_OutputToken = new Token((Object)key);
                        if (this.m_SuppressMissingKeyWarnings) break;
                        this.getLogger().warning("Key '" + key + "' not available from lookup table '" + this.m_StorageName + "', using key!");
                        break;
                    }
                    case OUTPUT_MISSING_VALUE: {
                        this.m_OutputToken = new Token((Object)this.m_MissingValue);
                        if (this.m_SuppressMissingKeyWarnings) break;
                        this.getLogger().warning("Key '" + key + "' not available from lookup table '" + this.m_StorageName + "', using missing value: " + this.m_MissingValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled missing key behavior: " + this.m_MissingKey);
                    }
                }
            }
        }
        return result;
    }
}

