/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.AbstractAnonymizer;
import adams.data.DoubleAnonymizer;
import adams.data.StringAnonymizer;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.ArrayList;
import java.util.Hashtable;

public class SpreadSheetAnonymize
extends AbstractSpreadSheetTransformer
implements Randomizable {
    private static final long serialVersionUID = -2767861909141864017L;
    public static final String BACKUP_MAPPING = "mapping";
    protected BaseRegExp m_ColumnsRegExp;
    protected long m_Seed;
    protected Hashtable<String, AbstractAnonymizer> m_Mapping;

    public String globalInfo() {
        return "Anonymizes a range of columns in a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col-regexp", "columnsRegExp", (Object)new BaseRegExp("^ID$"));
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    protected void initialize() {
        super.initialize();
        this.m_Mapping = new Hashtable();
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_MAPPING);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Mapping != null) {
            result.put(BACKUP_MAPPING, this.m_Mapping);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_MAPPING)) {
            this.m_Mapping = (Hashtable)state.get(BACKUP_MAPPING);
            state.remove(BACKUP_MAPPING);
        }
        super.restoreState(state);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"columnsRegExp", (BaseRegExp)this.m_ColumnsRegExp, (String)"cols: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        return result;
    }

    public void setColumnsRegExp(BaseRegExp value) {
        this.m_ColumnsRegExp = value;
        this.reset();
    }

    public BaseRegExp getColumnsRegExp() {
        return this.m_ColumnsRegExp;
    }

    public String columnsRegExpTipText() {
        return "The regular expression applied to the column names to locate the columns to anonymize.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the anonymizers.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (sheet.getRowCount() > 0) {
            int i;
            HeaderRow row = sheet.getHeaderRow();
            ArrayList<Boolean> numeric = new ArrayList<Boolean>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> id = new ArrayList<String>();
            for (i = 0; i < row.getCellCount(); ++i) {
                String colName = row.getCell(i).getContent();
                if (!this.m_ColumnsRegExp.isMatch(colName)) continue;
                names.add(colName);
                numeric.add(sheet.isNumeric(i, true));
                id.add(row.getCellKey(i));
                if (this.m_Mapping.containsKey(colName)) continue;
                if (((Boolean)numeric.get(numeric.size() - 1)).booleanValue()) {
                    this.m_Mapping.put(colName, (AbstractAnonymizer)new DoubleAnonymizer(colName, this.m_Seed, sheet.getRowCount()));
                    continue;
                }
                this.m_Mapping.put(colName, (AbstractAnonymizer)new StringAnonymizer(colName, this.m_Seed, sheet.getRowCount()));
            }
            if (names.size() > 0) {
                sheet = sheet.getClone();
                for (int n = 0; n < sheet.getRowCount(); ++n) {
                    row = sheet.getRow(n);
                    for (i = 0; i < names.size(); ++i) {
                        if (row.getCell((String)id.get(i)).isMissing()) continue;
                        Cell cell = row.getCell((String)id.get(i));
                        Object anon = (Boolean)numeric.get(i) != false ? this.m_Mapping.get(names.get(i)).anonymize((Object)cell.toDouble()) : this.m_Mapping.get(names.get(i)).anonymize((Object)cell.toString());
                        if (anon instanceof Double) {
                            cell.setContent((Double)anon);
                            continue;
                        }
                        cell.setContent((String)anon);
                    }
                }
            }
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

