/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SpreadSheetCellSelectionContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ColorHelper;
import adams.gui.core.Fonts;
import adams.gui.core.MouseUtils;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class SpreadSheetCellSelector
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -911540594631901631L;
    protected Font m_Font;
    protected Color m_ColorSelected;
    protected Table m_Table;
    protected TableModel m_TableModel;
    protected BaseButton m_ButtonOK;
    protected BaseButton m_ButtonCancel;
    protected boolean m_Accepted;
    protected Boolean m_Waiting;

    public String globalInfo() {
        return "Lets the user highlight cells in a spreadsheet which get output:\n- spreadsheet with coordinates (1-based row and column) and the associated value of the selected cell\n- spreadsheet with all un-selected cells set to missing\nUsage:\nYou select cells by left-clicking on them and/or holding the left mouse button and moving the mouse over the cells that you want to select.\nYou can unselect cells in the same fashion, by holding the shift key in addition.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font", "font", (Object)this.getDefaultFont());
        this.m_OptionManager.add("color-selected", "colorSelected", (Object)ColorHelper.valueOf((String)"#22FF0000"));
    }

    protected Font getDefaultFont() {
        return Fonts.getMonospacedFont();
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font of the table.";
    }

    public void setColorSelected(Color value) {
        this.m_ColorSelected = value;
        this.reset();
    }

    public Color getColorSelected() {
        return this.m_ColorSelected;
    }

    public String colorSelectedTipText() {
        return "The (background) color for the selected cells.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheetCellSelectionContainer.class};
    }

    public void clearPanel() {
        if (this.m_Table != null) {
            this.m_TableModel = new TableModel();
            this.m_Table.setModel((javax.swing.table.TableModel)((Object)this.m_TableModel));
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TableModel = new TableModel();
        this.m_Table = new Table(this.m_TableModel);
        this.m_Table.setFont(this.m_Font);
        result.add((Component)new BaseScrollPane((Component)((Object)this.m_Table)), (Object)"Center");
        return result;
    }

    protected BaseDialog doCreateDialog(BasePanel panel) {
        final BaseDialog result = super.doCreateDialog(panel);
        result.setModalityType(Dialog.ModalityType.MODELESS);
        result.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (SpreadSheetCellSelector.this.m_Waiting.booleanValue()) {
                    SpreadSheetCellSelector.this.m_Accepted = false;
                    SpreadSheetCellSelector.this.m_Waiting = false;
                }
            }
        });
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        result.getContentPane().add((Component)panelButtons, "South");
        this.m_ButtonOK = new BaseButton("OK");
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetCellSelector.this.m_Accepted = true;
                SpreadSheetCellSelector.this.m_Waiting = false;
                result.setVisible(false);
            }
        });
        panelButtons.add((Component)this.m_ButtonOK);
        this.m_ButtonCancel = new BaseButton("Cancel");
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetCellSelector.this.m_Accepted = false;
                SpreadSheetCellSelector.this.m_Waiting = false;
                result.setVisible(false);
            }
        });
        panelButtons.add((Component)this.m_ButtonCancel);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doInteract() {
        int i;
        String result = null;
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_Dialog.setVisible(true);
        SpreadSheet original = (SpreadSheet)this.m_InputToken.getPayload(SpreadSheet.class);
        this.m_TableModel = new TableModel(original);
        this.m_Table.setModel((javax.swing.table.TableModel)((Object)this.m_TableModel));
        CellRenderer renderer = new CellRenderer(this.m_ColorSelected);
        for (i = 0; i < this.m_Table.getColumnCount(); ++i) {
            this.m_Table.getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.m_Waiting = true;
        while (this.m_Waiting.booleanValue() && !this.isStopped()) {
            try {
                SpreadSheetCellSelector spreadSheetCellSelector = this;
                synchronized (spreadSheetCellSelector) {
                    ((Object)((Object)this)).wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Accepted) {
            SpreadSheet subset = original.getClone();
            DefaultSpreadSheet selected = new DefaultSpreadSheet();
            HeaderRow row = selected.getHeaderRow();
            row.addCell("R").setContentAsString("Row");
            row.addCell("C").setContentAsString("Column");
            row.addCell("V").setContentAsString("Value");
            for (int n = 0; n < this.m_Table.getRowCount(); ++n) {
                for (i = 0; i < this.m_Table.getColumnCount(); ++i) {
                    int col = i;
                    if (this.m_Table.getShowRowColumn()) {
                        --col;
                    }
                    if (col < 0) continue;
                    if (this.m_Table.isSelected(n, i)) {
                        row = selected.addRow();
                        row.addCell("C").setContent(Integer.valueOf(col + 1));
                        row.addCell("R").setContent(Integer.valueOf(n + 1));
                        row.addCell("V").setNative(this.m_Table.getValueAt(n, i));
                        continue;
                    }
                    if (subset.getCell(n, col) == null) continue;
                    subset.getCell(n, col).setMissing();
                }
            }
            this.m_OutputToken = new Token((Object)new SpreadSheetCellSelectionContainer(original, (SpreadSheet)selected, subset));
        } else {
            result = "Interaction canceled!";
        }
        return result;
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6070112998601610760L;
        protected Color m_CellSelectedColor;

        public CellRenderer(Color cellSelectedColor) {
            this.m_CellSelectedColor = cellSelectedColor;
        }

        public Color getCellSelectedColor() {
            return this.m_CellSelectedColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean cellSelected;
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Table spTable = (Table)((Object)table);
            TableModel model = (TableModel)((Object)spTable.getUnsortedModel());
            CellRenderingCustomizer rend = spTable.getCellRenderingCustomizer();
            Cell cell = spTable.getCellAt(row, column);
            int align = 2;
            if (cell != null && cell.isNumeric()) {
                align = 4;
            }
            Color bgcolor = (cellSelected = model.isSelected(spTable.getActualRow(row), column)) ? (isSelected ? this.m_CellSelectedColor.darker() : this.m_CellSelectedColor) : rend.getBackgroundColor((SpreadSheetTable)spTable, isSelected, hasFocus, row, column, cell, isSelected ? table.getSelectionBackground() : table.getBackground());
            ((JLabel)result).setHorizontalAlignment(rend.getHorizontalAlignment((SpreadSheetTable)spTable, isSelected, hasFocus, row, column, cell, align));
            ((JLabel)result).setToolTipText(rend.getToolTipText((SpreadSheetTable)spTable, isSelected, hasFocus, row, column, cell, null));
            result.setForeground(rend.getForegroundColor((SpreadSheetTable)spTable, isSelected, hasFocus, row, column, cell, isSelected ? table.getSelectionForeground() : table.getForeground()));
            result.setBackground(bgcolor);
            result.setFont(rend.getFont((SpreadSheetTable)spTable, isSelected, hasFocus, row, column, cell, result.getFont()));
            return result;
        }
    }

    public static class Table
    extends SpreadSheetTable {
        private static final long serialVersionUID = -2326881966143723401L;
        protected boolean m_Selecting;
        protected boolean m_Recording;

        public Table(SpreadSheet sheet) {
            this(new TableModel(sheet));
        }

        public Table(TableModel model) {
            super((SpreadSheetTableModel)model);
        }

        protected void initGUI() {
            super.initGUI();
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.m_Selecting = true;
            this.m_Recording = false;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    m_Selecting = !e.isShiftDown();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    m_Selecting = !e.isShiftDown();
                }
            });
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.check();
                }
            });
            this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.check();
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.check(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.check(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    m_Recording = MouseUtils.isLeftClick((MouseEvent)e);
                    this.check(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    m_Recording = MouseUtils.isLeftClick((MouseEvent)e);
                    this.check(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    m_Recording = false;
                    this.check(e);
                }
            });
        }

        protected void check(MouseEvent e) {
            if (MouseUtils.isLeftClick((MouseEvent)e)) {
                int col = this.columnAtPoint(e.getPoint());
                int row = this.rowAtPoint(e.getPoint());
                if (col < 0 || col >= this.getColumnCount()) {
                    return;
                }
                if (row < 0 || row >= this.getRowCount()) {
                    return;
                }
                if (this.setSelected(row, col, this.m_Selecting)) {
                    this.tableChanged(new TableModelEvent(this.getModel(), row, row, col, col));
                }
            }
        }

        protected void check() {
            int col;
            if (!this.m_Recording) {
                return;
            }
            Point tableTopLeft = this.getLocationOnScreen();
            Point mousePos = MouseInfo.getPointerInfo().getLocation();
            Point posOnTable = new Point(mousePos.x - tableTopLeft.x, mousePos.y - tableTopLeft.y);
            int row = this.rowAtPoint(posOnTable);
            if (this.setSelected(row, col = this.columnAtPoint(posOnTable), this.m_Selecting)) {
                this.tableChanged(new TableModelEvent(this.getModel(), row, row, col, col));
            }
        }

        public void setModel(javax.swing.table.TableModel model) {
            if (!(model instanceof TableModel)) {
                throw new IllegalArgumentException("Model must be of type " + Utils.classToString(TableModel.class));
            }
            super.setModel(model);
        }

        public boolean setSelected(int row, int col, boolean selected) {
            return ((TableModel)((Object)this.getUnsortedModel())).setSelected(this.getActualRow(row), col, selected);
        }

        public boolean isSelected(int row, int col) {
            return ((TableModel)((Object)this.getUnsortedModel())).isSelected(this.getActualRow(row), col);
        }
    }

    public static class TableModel
    extends SpreadSheetTableModel {
        private static final long serialVersionUID = -4690101744247172908L;
        protected boolean[][] m_Selected;

        public TableModel() {
            this((SpreadSheet)new DefaultSpreadSheet());
        }

        public TableModel(SpreadSheet sheet) {
            this(sheet, -1);
        }

        public TableModel(SpreadSheet sheet, int numDec) {
            super(sheet, numDec);
            this.m_Selected = new boolean[sheet.getRowCount()][sheet.getColumnCount()];
        }

        public boolean setSelected(int row, int col, boolean selected) {
            if (this.getShowRowColumn()) {
                --col;
            }
            if (row >= 0 && row < this.m_Selected.length && col >= 0 && col < this.m_Selected[row].length && selected != this.m_Selected[row][col]) {
                this.m_Selected[row][col] = selected;
                return true;
            }
            return false;
        }

        public boolean isSelected(int row, int col) {
            if (this.getShowRowColumn()) {
                --col;
            }
            if (row >= 0 && row < this.m_Selected.length && col >= 0 && col < this.m_Selected[row].length) {
                return this.m_Selected[row][col];
            }
            return false;
        }
    }
}

