/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.annotation.DeprecatedClass;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.multispreadsheetoperation.CommonIDs;
import java.util.HashSet;

@DeprecatedClass(useInstead={CommonIDs.class})
public class SpreadSheetCommonIDs
extends AbstractTransformer {
    private static final long serialVersionUID = 3363405805013155845L;
    protected SpreadSheetColumnIndex m_Index;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Extracts the common IDs from two or more spreadsheets.\nMatching sense can be inverted, i.e., the IDs not in common are output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setIndex(SpreadSheetColumnIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the column with the IDs in the spreadsheet.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "Whether to invert the matching sense and return the IDs 'not' in common.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)((Object)this.m_Index), (String)"col: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"invert", (boolean)this.m_Invert, (String)"invert", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet[].class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        SpreadSheet[] sheets;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof SpreadSheet[]) {
            sheets = (SpreadSheet[])this.m_InputToken.getPayload();
            if (sheets.length < 2) {
                result = "At least two spreadsheets required, provided: " + sheets.length;
            }
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        if (result == null) {
            int i;
            HashSet[] ids = new HashSet[sheets.length];
            for (i = 0; i < sheets.length; ++i) {
                this.m_Index.setData(sheets[i]);
                if (this.m_Index.getIntIndex() == -1) {
                    result = "Sheet #" + (i + 1) + " does not have column: " + this.m_Index;
                }
                ids[i] = new HashSet(sheets[i].getCellValues(this.m_Index.getIntIndex()));
            }
            if (result == null) {
                HashSet subset = new HashSet(ids[0]);
                for (i = 1; i < sheets.length; ++i) {
                    if (this.m_Invert) {
                        subset.removeAll(ids[i]);
                        continue;
                    }
                    subset.retainAll(ids[i]);
                }
                DefaultSpreadSheet output = new DefaultSpreadSheet();
                HeaderRow row = output.getHeaderRow();
                row.addCell("I").setContent("ID");
                for (String id : subset) {
                    output.addRow().addCell("I").setContentAsString(id);
                }
                this.m_OutputToken = new Token((Object)output);
            }
        }
        return result;
    }
}

