/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.DateTimeMsec;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.TimeMsec;
import adams.core.option.OptionHandler;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.Iterator;

public class SpreadSheetConvertHeaderCells
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -4633161214275622241L;
    protected boolean m_SkipMissing;
    protected String m_MissingReplacementValue;
    protected Cell.ContentType m_MissingReplacementType;
    protected Conversion m_Conversion;

    public String globalInfo() {
        return "Converts the header cells of a spreadsheet with a conversion scheme.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-missing", "skipMissing", (Object)true);
        this.m_OptionManager.add("missing-replacement-value", "missingReplacementValue", (Object)"");
        this.m_OptionManager.add("missing-replacement-type", "missingReplacementType", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("conversion", "conversion", (Object)new ObjectToObject());
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)this.m_Conversion, (String)"conversion: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"skipMissing", (boolean)this.m_SkipMissing, (String)"skip missing", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setSkipMissing(boolean value) {
        this.m_SkipMissing = value;
        this.reset();
    }

    public boolean getSkipMissing() {
        return this.m_SkipMissing;
    }

    public String skipMissingTipText() {
        return "If enabled, missing cells are skipped.";
    }

    public void setMissingReplacementValue(String value) {
        this.m_MissingReplacementValue = value;
        this.reset();
    }

    public String getMissingReplacementValue() {
        return this.m_MissingReplacementValue;
    }

    public String missingReplacementValueTipText() {
        return "The string representation of the value to use for replacing missing values.";
    }

    public void setMissingReplacementType(Cell.ContentType value) {
        this.m_MissingReplacementType = value;
        this.reset();
    }

    public Cell.ContentType getMissingReplacementType() {
        return this.m_MissingReplacementType;
    }

    public String missingReplacementTypeTipText() {
        return "The data type to use for the replacement value for missing values.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to apply to the header cells.";
    }

    protected String convertCell(Cell cell, SpreadSheet sheet) {
        Object result = null;
        Object input = null;
        Object output = null;
        if (cell.isMissing()) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        Class classIn = this.m_Conversion.accepts();
        Class classOut = this.m_Conversion.generates();
        if (input == null) {
            if (classIn == Double.class) {
                input = cell.toDouble();
            } else if (classIn == Integer.class) {
                input = cell.toLong().intValue();
            } else if (classIn == Long.class) {
                input = cell.toLong();
            } else if (classIn == Date.class) {
                input = cell.toDate();
            } else if (classIn == DateTime.class) {
                input = cell.toDateTime();
            } else if (classIn == DateTimeMsec.class) {
                input = cell.toDateTimeMsec();
            } else if (classIn == Time.class) {
                input = cell.toTime();
            } else if (classIn == TimeMsec.class) {
                input = cell.toTimeMsec();
            } else if (classIn == String.class) {
                input = cell.getContent();
            } else if (classIn == Object.class) {
                input = cell.getNative();
            } else if (classIn == Unknown.class) {
                input = cell.getNative();
            } else {
                result = "Don't know how to get cell value for conversion input type: " + classIn.getName();
            }
        }
        if (result == null) {
            this.m_Conversion.setInput(input);
            result = this.m_Conversion.convert();
        }
        if (result == null) {
            output = this.m_Conversion.getOutput();
            this.m_Conversion.cleanUp();
            if (classOut == Double.class) {
                cell.setContent((Double)output);
            } else if (classOut == Integer.class) {
                cell.setContent((Integer)output);
            } else if (classOut == Long.class) {
                cell.setContent((Long)output);
            } else if (classOut == Date.class) {
                cell.setContent((Date)output);
            } else if (classOut == DateTime.class) {
                cell.setContent((DateTime)output);
            } else if (classOut == DateTimeMsec.class) {
                cell.setContent((DateTimeMsec)output);
            } else if (classOut == Time.class) {
                cell.setContent((Time)output);
            } else if (classOut == TimeMsec.class) {
                cell.setContent((TimeMsec)output);
            } else if (classOut == String.class) {
                if (((String)output).startsWith("=")) {
                    cell.setContent((String)output);
                } else {
                    cell.setContentAsString((String)output);
                }
            } else if (classOut == Object.class) {
                cell.setNative(output);
            } else if (classOut == Unknown.class) {
                cell.setNative(output);
            } else {
                result = "Don't know how to set cell value for conversion output type: " + classOut.getName();
            }
        }
        return result;
    }

    protected String doExecute() {
        Cell cell;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator iterator = sheetNew.getHeaderRow().cells().iterator();
        while (iterator.hasNext() && (result = this.convertCell(cell = (Cell)iterator.next(), sheetNew)) == null && !this.isStopped()) {
        }
        if (result == null && !this.isStopped()) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        this.m_Conversion.stopExecution();
    }
}

