/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetCopyRows
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected Range m_Rows;
    protected Index m_Position;
    protected boolean m_After;

    public String globalInfo() {
        return "Copies a range of columnrows to a specific position in the spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnIndex();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("position", "position", (Object)new Index("first"));
        this.m_OptionManager.add("after", "after", (Object)false);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)"rows: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? (String)result + ", at/after: " : (this.m_After ? (String)result + ", after: " : (String)result + ", at: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)this.m_Position);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The range of rows to copy";
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the rows.";
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the rows are inserted after the position instead of at the position.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        this.m_Rows.setMax(sheetOld.getRowCount());
        int[] fromPos = this.m_Rows.getIntIndices();
        int[] toPos = new int[fromPos.length];
        this.m_Position.setMax(sheetOld.getRowCount());
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        for (i = 0; i < toPos.length; ++i) {
            toPos[i] = pos + i;
        }
        for (i = 0; i < fromPos.length; ++i) {
            sheetNew.insertRow(toPos[i]).assign((Row)sheetOld.getRow(fromPos[i]));
        }
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

