/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.AbstractArrayProvider;

public class SpreadSheetExtractArray
extends AbstractArrayProvider {
    private static final long serialVersionUID = -3989993009528522476L;
    protected ExtractionType m_Type;
    protected Index m_Index;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Extracts a column or row of data from a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)ExtractionType.COLUMN);
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("use-native", "useNative", (Object)true);
    }

    protected Class getItemClass() {
        if (this.m_UseNative) {
            return Object.class;
        }
        return String.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the values are output as array instead of one-by-one.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)this.m_Index, (String)": ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setType(ExtractionType value) {
        this.m_Type = value;
        this.reset();
    }

    public ExtractionType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of extraction to perform, row or column.";
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the row/column to extract.";
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are output rather than strings.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result;
        block9: {
            result = null;
            this.m_Queue.clear();
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (this.m_Type == ExtractionType.COLUMN) {
                this.m_Index.setMax(sheet.getColumnCount());
            } else {
                this.m_Index.setMax(sheet.getRowCount());
            }
            int index = this.m_Index.getIntIndex();
            if (index == -1) {
                result = "Invalid index: " + this.m_Index + " (max=" + this.m_Index.getMax() + ")";
            }
            if (result != null) break block9;
            if (this.m_Type == ExtractionType.COLUMN) {
                for (int i = 0; i < sheet.getRowCount(); ++i) {
                    Cell cell = sheet.getCell(i, index);
                    if (cell == null || cell.isMissing()) continue;
                    if (this.m_UseNative) {
                        this.m_Queue.add(cell.getNative());
                        continue;
                    }
                    this.m_Queue.add(cell.getContent());
                }
            } else {
                for (int i = 0; i < sheet.getColumnCount(); ++i) {
                    Cell cell = sheet.getCell(index, i);
                    if (cell == null || cell.isMissing()) continue;
                    if (this.m_UseNative) {
                        this.m_Queue.add(cell.getNative());
                        continue;
                    }
                    this.m_Queue.add(cell.getContent());
                }
            }
        }
        return result;
    }

    public static enum ExtractionType {
        COLUMN,
        ROW;

    }
}

